/*****************************************************************************
*									                                                  *                                           *               FlightSafety International, Inc.                             *
*               Simulation Systems Division                                  *
*               2700 North Hemlock Circle                                    *
*               Broken Arrow, Oklahoma  74012     (918) 251-0500             *
*									                                                  *
******************************************************************************
*                                                                            *
*   Title:      Handle Configuration File Information                        *
*                                                                            *
*   Filename:   pre_cnfg.h                                                   *
*                                                                            *
*   Author:     Terry Tyler                                                  *
*                                                                            *
*   Function:   This file contains programs to read in the configuration     *
*               file ../exec/Config and to provide pointers to the           *
*               information.                                                 *
*                                                                            *
******************************************************************************
*                                                                            *
*   REVISION HISTORY                                                         *
*   ================                                                         *
*                                                                            *
*   REV     DATE           REASON                                            *
*   ---     ------------   -----------------------------------------------   *
*   1.1     MAY 05, 1994   ORIGINAL STANDARD RELEASE                         *
*                                                                            *
******************************************************************************/

#ifndef NAVCONFIG_H
#define NAVCONFIG_H

#ifdef NAVCNFG_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN
#endif

/****************************************************
**  Function Prototypes                            **
****************************************************/

EXTERN int  readConfigFile( void );
EXTERN char *GetConfig( char *configItem );
EXTERN int  GetConfigInt( char *configItem );

/** Configuration Parameters  **/

#define CONFIG_DATA_PATH            "DataPath"
#define CONFIG_ARINC_FILENAME       "ArincName"
#define CONFIG_SRC_FILENAME	        "SourceName"
#define CONFIG_RDB_FILENAME         "RDBName"
#define CONFIG_TEMP_FILENAME        "TempName"
#define CONFIG_ALNLIST_FILENAME     "AlignListName"
#define CONFIG_SORT_FILENAME        "SortName"
#define CONFIG_DEST_FILENAME        "DestName"
#define CONFIG_ERROR_FILENAME       "ErrorName"
#define CONFIG_RUNTIME_FILENAME     "RunTimeName"

#define CONFIG_ADD_FILE             "AddFile"

#define CONFIG_ARINC_REV            "ArincFmt"
#define CONFIG_ALIGN_RDB            "AlignRdb"
#define CONFIG_UPDATE_OPTION        "UpdateOption"
#define CONFIG_VERBOSE_OPTION       "VerboseOption"
#define CONFIG_COMPILE_OPTION       "CompileOption"
#define CONFIG_DIAG_OPTION          "DiagnosticOption"

#endif