/*   @(#) handleConfig.c  1.3   5/25/94   14:51:57   STANDARD RELEASE   */
/******************************************************************************
 *                                                                            *
 *               FlightSafety International, Inc.                             *
 *               Simulation Systems Division                                  *
 *               2700 North Hemlock Circle                                    *
 *               Broken Arrow, Oklahoma  74012     (918) 251-0500             *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 *   Title:      Handle Configuration File Information                        *
 *                                                                            *
 *   Filename:   handleConfig.c                                               *
 *                                                                            *
 *   Author:     Molly A. Ward                                                *
 *                                                                            *
 *   Function:   This file contains programs to read in the configuration     *
 *               file ../exec/Config and to provide pointers to the           *
 *               information.                                                 *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 *   REVISION HISTORY                                                         *
 *   ================                                                         *
 *                                                                            *
 *   REV     DATE           REASON                                            *
 *   ---     ------------   -----------------------------------------------   *
 *   1.1     MAY 05, 1994   ORIGINAL STANDARD RELEASE                         *
 *                                                                            *
 ******************************************************************************/
/*****************************************************************
*  RCS Revision History
******************************************************************
*
* $Id:  $
* $Log: $ 
*
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*#include "define.h"*/
#include <reusable_cat.h>

#define INITCONFIG 20
#define INCRCONFIG 10

#ifndef FILENAME_LEN
#define FILENAME_LEN 80
#endif

static char *ConfigFileName="../exec/Config";
static char *DefaultConfig="???";
static char *LocalConfigFileName="./config";

static int currAlloc=0;
static int numConfig=0;
static char **ConfigDescs;
static char **ConfigItems;

/*  Function Prototypes */
#define NAVCNFG_PROTOTYPES
#include "navConfig.h"

static char **chgPtrArry(char **currPtr, int newElmts );
static char *ConfigRead255Line( FILE *File );

static char msgstr[80];			/* String for MessageLog */

/******************************************************************************
 *                                                                            *
 * Allocates memory for the configuration description and item pointers.      *
 *                                                                            *
 ******************************************************************************/ 
static char **chgPtrArry(currPtr, newElmts)
 char **currPtr;
 int newElmts;
{
 static char *procName = "[handleConfig.c] chgPtrArry():";
 char **newPtr;
 size_t newSize;
 
				/* Allocate the memory requested              */
 newSize = newElmts * sizeof(char **);
 if(currPtr)
    newPtr = (char **)realloc(currPtr, newSize);
 else
    newPtr = (char **)malloc(newSize);

 if(!newPtr)
 {
    sprintf(msgstr,"%s Unable to allocate enough memory for %d elements.\n",
                  procName, newSize);
    JPATS_Log_Report (msgstr, JPATS_Log_Error);
    
    exit(1);
 }

 return(newPtr);
}


/******************************************************************************
 *                                                                            *
 * Reads in a line from the configuration FILE and removes the newline        *
 * character.                                                                 *
 *                                                                            *
 ******************************************************************************/

static char *ConfigRead255Line(File)
FILE *File;
{
   static char Line[255];
   int cnt, len;


   if(fgets(Line, 255, File) != NULL)
   {
      len = strlen(Line);
      for(cnt=0;cnt<len;cnt++)
      {
         if(Line[cnt] == '\n')
            Line[cnt] = '\0';
      }
      return(Line);
   }
   else return(NULL);
}


/******************************************************************************
 *                                                                            *
 * Allocates memory for the requested string.                                 *
 *                                                                            *
 ******************************************************************************/

static char *ConfigCreateString(char *str)
{
   char *ret = malloc(sizeof(char)*(strlen(str)+1));


   if(ret) strcpy(ret, str);
   return(ret);
}


/******************************************************************************
 *                                                                            *
 * Gets the next white-space-separated string from the provided string.       *
 *                                                                            *
 ******************************************************************************/

static char *ConfigGetStr(char **str)
{
   char *pos, *ret;
   int add;
   static char string[FILENAME_LEN];


   sscanf(*str, "%s", string);

   ret = ConfigCreateString(string);

   pos = strstr(*str, string);

   add = pos - *str;

   *str += strlen(string) + add;

   return(ret);
}


/****************************************************************************** 
 *                                                                            * 
 * Reads in the configuration file contents.                                  * 
 *                                                                            * 
 ******************************************************************************/

int readConfigFile()
{
   static char *procName="[handleConfig.c] readConfigFile():";
   FILE *FPtr;
   char *Str, *colon, *string;

					/* Allocate memory for the pointers   */
   currAlloc = INITCONFIG;
   ConfigDescs = chgPtrArry(NULL, currAlloc);
   ConfigItems = chgPtrArry(NULL, currAlloc);

   if( (FPtr = fopen( LocalConfigFileName,"r" )) != NULL ) 
   {
     sprintf(msgstr, "%s Using Config file: %s\n",procName,LocalConfigFileName );
     JPATS_Log_Report (msgstr, JPATS_Log_Informational);
   }
   else if( (FPtr = fopen( ConfigFileName,"r" )) != NULL )
   {
     sprintf(msgstr, "%s Using Config file: %s\n",procName,ConfigFileName );
     JPATS_Log_Report (msgstr, JPATS_Log_Informational);
   }
   else
   {
     sprintf(msgstr, "%s Error opening file: %s\n",procName,ConfigFileName );
     JPATS_Log_Report (msgstr, JPATS_Log_Error);
   }
   if( FPtr != NULL )
   {					/* Read a configuration line	      */
      while((Str = ConfigRead255Line(FPtr)) != NULL)
      {					/* Comment or blank line	      */
	 if(Str[0] == '#' || Str[0] == '\0')
	    continue;
					/* Get configuration description and  */
					/* remove the trailing colon	      */
	 *(ConfigDescs+numConfig) = ConfigGetStr(&Str);
         if( (colon = strstr(*(ConfigDescs+numConfig), ":")) )
             *colon = (char)NULL;
					/* Get configuration item(s)	      */
         string = ConfigCreateString(Str);
	 *(ConfigItems+numConfig) = string+strspn(string, "\t ");

         numConfig++;
         if( numConfig == currAlloc )	/* Check if need more memory	      */
         {
             currAlloc += INCRCONFIG;
             ConfigDescs = chgPtrArry(ConfigDescs, currAlloc);
             ConfigItems = chgPtrArry(ConfigItems, currAlloc);
         }
      }

      currAlloc = numConfig;		/* Allocate exact amount of memory    */
      ConfigDescs = chgPtrArry(ConfigDescs, currAlloc);
      ConfigItems = chgPtrArry(ConfigItems, currAlloc);

      fclose(FPtr);
      return(0);
   }
   else					/* Cannot find configuration file so  */
   {					/* setup default values		      */
      *(ConfigDescs+numConfig) = ConfigCreateString(DefaultConfig);
      *(ConfigItems+numConfig) = ConfigCreateString(DefaultConfig);
					/* Allocate exact amount of memory    */
      currAlloc = ++numConfig;
      ConfigDescs = chgPtrArry(ConfigDescs, currAlloc);
      ConfigItems = chgPtrArry(ConfigItems, currAlloc);

      sprintf(msgstr, "%s Unable to open %s\nSetting Default to %s\n",
             procName, ConfigFileName, *ConfigItems);
      JPATS_Log_Report (msgstr, JPATS_Log_Warning);

      return(1);
   }
}


/****************************************************************************** 
 *                                                                            * 
 * Returns the string value of the requested configuration item if valid.     * 
 * Otherwise returns the default configuration item.                          * 
 *                                                                            * 
 ******************************************************************************/

char *GetConfig(configItem)
 char *configItem;
{
 static char *procName="[handleConfig.c] GetConfig():";
 int ccnt;

 if( numConfig == 0 )
   readConfigFile();

 for( ccnt=0; ccnt<numConfig; ccnt++ )
 {
      if( !strcmp(*(ConfigDescs+ccnt), configItem) )
          return(*(ConfigItems+ccnt));
 }

 sprintf(msgstr, "%s Unable to find Configuration item %s\nReturning the default %s\n",
	 procName, configItem, DefaultConfig);
 JPATS_Log_Report (msgstr, JPATS_Log_Warning);

 return(DefaultConfig);
}


/****************************************************************************** 
 *                                                                            * 
 * Returns the integer value of the requested configuration item if valid.    * 
 * Otherwise returns EOF.                                                     * 
 *                                                                            * 
 ******************************************************************************/

int GetConfigInt(configItem)
 char *configItem;
{
 int iConfig=0, iRtn;
 char *sConfig;


 sConfig = GetConfig(configItem);
 if( sConfig[0] == '?' )  return( EOF );
 iRtn = sscanf(sConfig, "%d", &iConfig);
 if( iRtn != EOF)
     return(iConfig);
 else
     return(iRtn);
}
/*****  end of handleConfig.c  *****/
