/*****************************************************************
**                                                              **
**  FlightSafety International, Inc.                            **
**  2700 North Hemlock Circle                                   **
**  Broken Arrow, Oklahoma 74012                                **
**  (918) 251-0500                                              **
**                                                              **
******************************************************************
**                                                              **
**  The information contained herein is the property of         **
**  FlightSafety Simulation Systems Division and shall          **
**  not be copied or used in any manner or disclosed to         **
**  others execpt as expressly authorized by FSI-SSD.           **
**                                                              **
******************************************************************
**                                                              **
**  Department: Navigation/Visual (65)                          **
**                                                              **
**  Task:       Radio database definitions.                     **
**  Author:     Terry Tyler                                     **
**                                                              **
**  Revision:   1.15          Date: 03/Jun/94                   **
**                                                              **
*****************************************************************/

#ifndef NAV_RDBDEF_H
#define NAV_RDBDEF_H


/*****************************************************************
**	Revision History					**
*****************************************************************/

/* Rev 1.00 - 11/21/89	T.Tyler-Initial program release.	*/
/* Rev 1.01 - 03/19/90	T.Tyler-Added Alignment channel def.	*/
/* Rev 1.02   04/20/90  T.Tyler-Added g/s to threshold dist for	**
**			ILS & MLS facility types.		*/
/* Rev 1.03   --/--/--  T.Tyler-No Changes.			*/
/* Rev 1.04   06/11/90  T.Tyler-No Chagnes.			*/
/* Rev 1.05   12/Nov/90	T.Tyler-No Changes.			*/
/* Rev 1.06   06/dec/90	T.Tyler-No Changes.			*/
/* Rev 1.07   16/May/91	T.Tyler-No Changes.			*/
/* Rev 1.08   18/Jul/91 T.Tyler-No Changes.			*/
/* Rev 1.09   03/Oct/91	T.Tyler-No Changes.			*/
/* Rev 1.10   23/Oct/91	T.Tyler-No Changes			*/
/* Rev 1.11   12/Mar/92	T.Tyler-No Changes.			*/
/* Rev 1.12   13/Jul/92	T.Tyler-No Changes.			*/
/* Rev 1.13   13/Nov/92	T.Tyler-Allocate a spare APT word for	**
**			the airport ATA identifier.		*/
/* Rev 1.14  23/Sep/93	T.Tyler-No changes.			*/
/* Rev 1.15  03/Jun/94	T.Tyler-Changed to run w/gcc compiler.	*/

/*********************************************************
**							**
**	rdbdef.h -					**
**		contains the basic radio database	**
**		definitions/declarations used by the	**
**		the associated nav modules.		**
**							**
*********************************************************/

/*** miscellaneous defintions   ***/

/*** receiver types definition  ***/

#define OFF   0			/* OFF - inactive channel */
#define ALN   1			/* ALN - Alignment channel */
#define NAV   2			/* NAV - VHF NAV (VOR/ILS) */
#define MLS   3			/* MLS - Microwave Landing System */
#define DME   4			/* DME - Distance Measuring Equipment */
#define TAC   5			/* TAC - TACAN system */
#define NDB   6			/* NDB - NDB-ADF system */
#define COM   7			/* COM - Communications */
#define MKR   8			/* MKR - Marker Beacon System OM/MM/IM */
#define DMY   9			/* DMY - Spare Type */
#define END  10			/* END - End of Table Flag */

#define OMKR  0				/* Marker Subtype */
#define MMKR  1
#define IMKR  2				/* IM/AWM	*/

#define ILS_MASK 0x40000000
#define MLS_MASK 0x20000000
#define VOR_MASK 0x10000000
#define DME_MASK 0x0C000000		/* DME or TACAN */
#define TAC_MASK 0x0C000000		/* DME or TACAN */
#define VHF_MASK 0X1C000000		/* VOR | DME | TAC  */
#define NDB_MASK 0x00800000
#define AWM_MASK 0x00400000
#define COM_MASK 0x00200000
#define APT_MASK 0x00008000
#define RWY_MASK 0x00004000
#define ENR_MASK 0x00002000
#define EWP_MASK 0x00001000
#define TWP_MASK 0x00000800
#define WPT_MASK 0x00001800		/* EWP | TWP	*/
#define HLD_MASK 0x00000400

#define TYPE_VHF_VOICE	0X40000000
#define TYPE_VHF_PDME	0X10000000
#define TYPE_VHF_APPR	0X08000000
#define TYPE_VHF_DEP	0X04000000
#define TYPE_VHF_ATIS	0X02000000
#define TYPE_VHF_VOT	0X00400000
#define TYPE_VHF_VOT_ID	0X00300000	/* 2 bits for VOT ident */

#define TYPE_NDB_VOICE		0X40000000
#define TYPE_NDB_BFO		0X20000000
#define TYPE_NDB_BFO_TYPE	0X18000000
#define TYPE_NDB_EMISS		0X04000000
#define TYPE_NDB_IMKR		0X02000000
#define TYPE_NDB_MMKR		0X01000000
#define TYPE_NDB_OMKR		0X00800000
#define TYPE_NDB_SABH		0X00400000
#define TYPE_NDB_MARINE		0X00200000
#define TYPE_NDB_RATE		0X000F0000

#define TYPE_WPT_HIGH		0X08000000
#define TYPE_WPT_LOW		0X04000000
#define TYPE_WPT_5ID		0X000000FF

#define TYPE_AWM_VOICE		0X40000000
#define TYPE_AWM_IMKR		0X20000000
#define TYPE_AWM_MMKR		0X10000000
#define TYPE_AWM_OMKR		0X08000000
#define TYPE_AWM_LOC		0X02000000
#define TYPE_AWM_BM		0X01000000
#define TYPE_AWM_ZM		0X00800000
#define TYPE_AWM_FM		0X00400000
#define TYPE_AWM_BCB		0X00200000

#define TYPE_HP_VHF		0X40000000
#define TYPE_HP_NDB		0X20000000
#define TYPE_HP_ENR		0X10000000
#define TYPE_HP_HIGH		0X08000000
#define TYPE_HP_LOW		0X04000000
#define TYPE_HP_TURN		0X02000000
#define TYPE_HP_5ID		0X000000FF

#define TYPE_ENR_TYP		0XF0000000
#define TYPE_ENR_HIGH		0X08000000
#define TYPE_ENR_LOW		0X04000000
#define TYPE_ENR_CONT		0X00FF0000
#define TYPE_ENR_5ID		0X000000FF

#define TYPE_RWY_TDZE		0X0000FFFF

#define TYPE_ILS_VOICE		0X40000000
#define TYPE_ILS_BC		0X20000000
#define TYPE_ILS_PDME		0X10000000
#define TYPE_ILS_DME_POS	0X0C000000
#define TYPE_ILS_CAT		0X03000000
#define TYPE_ILS_LDA		0X00800000
#define TYPE_ILS_SDF		0X00400000
#define TYPE_ILS_GS		0X00200000
#define TYPE_ILS_LOC		0X00100000

#define TYPE_MLS_VOICE		0X40000000
#define TYPE_MLS_BC		0X20000000
#define TYPE_MLS_PDME		0X10000000
#define TYPE_MLS_DME_POS	0X0C000000
#define TYPE_MLS_CAT		0X03000000

#define TYPE_COM_VOICE		0X40000000
#define TYPE_COM_TWR		0X20000000
#define TYPE_COM_GND		0X10000000
#define TYPE_COM_APR		0X08000000
#define TYPE_COM_DEP		0X04000000
#define TYPE_COM_ATIS		0X02000000
#define TYPE_COM_CLR		0X01000000
#define TYPE_COM_CEN_H		0X00800000
#define TYPE_COM_CEN_L		0X00400000
#define TYPE_COM_FSS		0X00200000
#define TYPE_COM_UNIC		0X00100000
#define TYPE_COM_HELI		0X00080000
#define TYPE_COM_OPS		0X00040000
#define TYPE_COM_FRQ_LVL	0X00030000

/*** radio database definition  ***/

typedef union rdb_struct {
  short s[2];
  long l;
  char c[4];
} RDB;

typedef struct rdb_tbl {
  long start;		/*start tbl offset*/
  long end;		/*end   tbl offset*/
  long total;		/*total number    */
  long idxf;		/*idx (n**2) factor*/
  long indx;		/*search start offset*/
  RDB  *sptr;		/*tbl start addr  */
  RDB  *eptr;		/*tbl end   addr  */
  RDB  *iptr;		/*tbl search addr */
} RDB_IDX_TBL;

/***  Common Radio Database Definitions   ***/

#define RDB_IDNT  0		/* long words */
#define RDB_ICAO  1
#define RDB_TYP1  2
#define RDB_TYP2  3
#define RDB_LAT   4
#define RDB_LON   5
#define RDB_VAR   6		/* short words*/
#define RDB_VAR_S 0
#define RDB_ELV   6
#define RDB_ELV_S 1

/***  VHF Navaid Radio Database Definitions   ***/

#define VHF_REC_LENGTH 8
#define VHF_VAR   6
#define VHF_VAR_S 0
#define VHF_ELV   6
#define VHF_ELV_S 1
#define VHF_FRQ   7
#define VHF_FRQ_S 0
#define VHF_DCL   7
#define VHF_DCL_S 1

/***  NDB Navaid Radio Database Definitions   ***/
/*	(Uses same structure as vhf_struct	*/

#define NDB_REC_LENGTH 8
#define NDB_VAR   6
#define NDB_VAR_S 0
#define NDB_ELV   6
#define NDB_ELV_S 1
#define NDB_FRQ   7
#define NDB_FRQ_S 0
#define NDB_SP1   7
#define NDB_SP1_S 1

/***  Waypoint Radio Database Definitions   ***/

#define WPT_REC_LENGTH 8
#define WPT_VAR   6
#define WPT_VAR_S 0
#define WPT_SP1   6
#define WPT_SP1_S 1
#define WPT_SP2   7
#define WPT_SP2_S 0
#define WPT_SP3   7
#define WPT_SP3_S 1		/* Spare 3  */

/***   Airways Markers Radio Database Defintions   ***/

#define AWM_REC_LENGTH 8
#define AWM_VAR   6
#define AWM_VAR_S 0
#define AWM_ELV   6
#define AWM_ELV_S 1
#define AWM_FRQ   7
#define AWM_FRQ_S 0 
#define AWM_HDG   7
#define AWM_HDG_S 1

/***   Holding Pattern Radio Database Definitions   ***/

#define HP_REC_LENGTH 8
#define HP_CRS    6
#define HP_CRS_S  0
#define HP_LEN    6
#define HP_LEN_S  1
#define HP_SP1    7
#define HP_SP1_S  0
#define HP_SP2    7
#define HP_SP2_S  1

/***  Enroute Airways Radio Database Definitions   ***/

#define ENR_REC_LENGTH 16
#define ENR_LAT2   6
#define ENR_LON2   7
#define ENR_LAT3   8 
#define ENR_LON3   9
#define ENR_LAT4  10
#define ENR_LON4  11
#define ENR_LAT5  12
#define ENR_LON5  13
#define ENR_LAT6  14
#define ENR_LON6  15

/***   Airport Radio Database Definitions   ***/

#define APT_REC_LENGTH 16
#define APT_VAR    6
#define APT_VAR_S  0
#define APT_ELV    6
#define APT_ELV_S  1
#define APT_ATA    7
#define APT_ATA_S  0
#define APT_SP1    8
#define APR_SP1_S  0
#define APT_NAME   8
#define APT_NAME_S 1		/* 32 bytes */

/***   Runway Radio Database Definitions   ***/

#define RWY_REC_LENGTH 10
#define RWY_HDG    6
#define RWY_HDG_S  0
#define RWY_LEN    6
#define RWY_LEN_S  1
#define RWY_DTH    7
#define RWY_DTH_S  0
#define RWY_WID    7
#define RWY_WID_S  1
#define RWY_LID    8		/* long words */
#define RWY_AID    9		/* long word  */

/***   ILS Radio Database Definitions   ***/

#define ILS_REC_LENGTH 21
#define ILS_VAR   6
#define ILS_VAR_S 0		/* short variation */
#define ILS_ELV   6
#define ILS_ELV_S 1		/* short elevation */
#define ILS_FRQ   7
#define ILS_FRQ_S 0		/* short frequency */
#define ILS_HDG   7
#define ILS_HDG_S 1		/* short heading (T) */
#define ILS_AID    8		/* long apt ident  */
#define ILS_RID    9		/* long rwy ident  */ 
#define ILS_LGD   10
#define ILS_LGD_S  0 		/* short loc-G/S dist, ft */
#define ILS_LBW	  10
#define ILS_LBW_S  1		/* short loc beam width   */
#define ILS_GSA   11
#define ILS_GSA_S  0		/* short G/S angle */
#define ILS_GBW   11
#define ILS_GBW_S  1		/* short G/S beam width */
#define ILS_DLAT  12		/* long DME lat */
#define ILS_DLON  13		/* long DME lon */
#define ILS_ILAT  14		/* long IM  lat */
#define ILS_ILON  15		/* long IM  lon */
#define ILS_MLAT  16		/* long MM  lat */
#define ILS_MLON  17		/* long MM  lon */
#define ILS_OLAT  18		/* long OM  lat */
#define ILS_OLON  19		/* long OM  lon */
#define ILS_GTD   20		/* short g/s to threshold dist*/
#define ILS_GTD_S  0

/*** MLS Radio Database Definitions   ***/

#define MLS_REC_LENGTH 16
#define MLS_VAR    6
#define MLS_VAR_S  0	/* short mag variation */
#define MLS_ELV    6
#define MLS_ELV_S  1	/* short elevation, ft */
#define MLS_FRQ    7
#define MLS_FRQ_S  0	/* short frequency     */
#define MLS_HDG    7
#define MLS_HDG_S  1	/* short heading, true */
#define MLS_AID    8	/* long airport ident  */
#define MLS_RID    9	/* long runway  ident  */
#define MLS_AED   10
#define MLS_AED_S  0	/* short az-elev dist  */
#define MLS_APA   10
#define MLS_APA_S  1	/* short az porp. angle */
#define MLS_ACA   11
#define MLS_ACA_S  0	/* short az coverage ang.*/
#define MLS_EAS   11
#define MLS_EAS_S  1	/* short */
#define MLS_NEA   12
#define MLS_NEA_S  0	/* short nominal elev angle */
#define MLS_MGPA  12
#define MLS_MGPA_S 1	/* short min g/s angle  */
#define MLS_BATD  13
#define MLS_BATD_S 0	/* short */
#define MLS_BPA   13
#define MLS_BPA_S  1	/* short */
#define MLS_BCA   14
#define MLS_BCA_S  0 	/* short */
#define MLS_BHDG  14
#define MLS_BHDG_S 1	/* short */
#define MLS_GTD   14	/* g/s to threshold dist,ft */
#define MLS_GTD_S  0	/* short index */
#define MLS_SP1   15

/*** Comm Radio Database Definitions   ***/

#define COM_REC_LENGTH 8
#define COM_VAR   6
#define COM_VAR_S 0	/* short mag variation */
#define COM_ELV   6
#define COM_ELV_S 1	/* short elevation, ft.*/
#define COM_FRQ   7
#define COM_FRQ_S 0    /* short frequency,    */
#define COM_SP1   7
#define COM_SP1_S 1    /* short spare word 1  */

/***************************************************
**  Radio Database Runtime Record structures      **
***************************************************/

#endif
/***   end  of nav_rdbdef.h  ***/
