/*****************************************************************
**                                                              **
**  FlightSafety International, Inc.                            **
**  2700 North Hemlock Circle                                   **
**  Broken Arrow, Oklahoma 74012                                **
**  (918) 251-0500                                              **
**                                                              **
******************************************************************
**                                                              **
**  The information contained herein is the property of         **
**  FlightSafety Simulation Systems Division and shall          **
**  not be copied or used in any manner or disclosed to         **
**  others except as expressly authorized by FSI-SSD.           **
**                                                              **
******************************************************************
**                                                              **
**  Department: Navigation/Visual (65)                          **
**                                                              **
**  Task:       Navigation Standard Definitions.                **
**  Author:     Terry Tyler                                     **
**                                                              **
**  Revision:   1.18            Date: 27/Feb/98                 **
**  Revised by: Terry Tyler                                     **
**                                                              **
*****************************************************************/

#ifndef NAV_NAVDEF_H
#define NAV_NAVDEF_H

/*****************************************************************
**  Revision History:                                           **
*****************************************************************/
/*  Rev 1.00  12/27/89  T.Tyler-Initial software release.	*/
/*  Rev 1.01  03/21/90  T.Tyler-Added math.h reference, added	**
**                      airport runway declaration.		*/
/*  Rev 1.02  04/20/90  T.Tyler-Added g/s to threshold dist for	**
**                      ILS & MLS facilties (.gtd)		*/
/*  Rev 1.04  06/11/90  T.Tyler-Changed threshold to loc label.	*/
/*  Rev 1.05  08/08/90  T.Tyler-Expanded stn_kill_struct to 	**
**                      allow for kill mode variable		*/
/*  Rev 1.06  12/06/90  T.Tyler-Added transfer mode declaration.**
**                      Revised Rev level.			*/
/*  Rev 1.07  15/May/91 T.Tyler-Changed host command word to	**
**                      bit definitions.  Added analog model 	**
**                      for ADF/NDB searches.			**
**                      Added ident search to support radar	**
**                      storm positioning.			*/
/*  Rev 1.08  18/Jul/91 T.Tyler-Modified software level to 1.08	**
**                      changed database to dynamic allocation.	*/
/*  Rev 1.09  03/Oct/91 T.Tyler-Modified software level to 1.09	*/
/*  Rev 1.10  23/Oct/91 T.Tyler-Added new bit in the NSCMD word **
**                      to allow for marker kill options.	*/
/*  Rev 1.11  12/Mar/92 T.Tyler-Rearranged airport and runway	**
**                      structures to allow for correct element	**
**                      alignment.(Required for SPARK systems.)	*/
/*  Rev 1.12  13/Jul/92 T.Tyler-Rarranged IP structure to allow	**
**                      for correct alignment.			*/
/*  Rev 1.13  13/Nov/92 T.Tyler-Modified the host input struct	**
**                      to allow for multiple airports.  Added	**
**                      label for airport ATA ident.		**
**                      Added host option for ruwnay list order.*/
/*  Rev 1.14  23/Sep/93 T.Tyler-Implemented new comms option.	*/
/*  Rev 1.14a 01/Nov/93 T.Tyler-Expanded the rwy list options	**
**                      from two bits to three.			*/
/*  Rev 1.15  03/Jun/94 T.Tyler-Modified to run under gcc	**
**                      compilers.				*/
/*  Rev 1.16  13/Jun/95 T.Tyler-Modified to include magvar map.	*/
/*  Rev 1.17  27/Feb/96 T.Tyler-Changed release to R1.17	*/
/*  Rev 1.18  27/Feb/98 T.Tyler-Converted to run in harris      **
**                      environment.  Added GMT functions.      */

/*********************************************************
**  Software Release Level                              **
*********************************************************/

#define SOFTREV "NT-R2.00"

/*********************************************************
**  Radio Database Unit Assignment                      **
**   For single processor systems, the radio data       **
**   is loaded by the lexec, and attached to the        **
**   nav software through shared memory.  However,      **
**   the nav task may be different than the task        **
**   that loaded the database.  This defines where      **
**   the database has been loaded from.  CAUTION:       **
**   If the lexec task that loads the database is       **
**   changed, then this define may need changing.       **
*********************************************************/

#define RDB_UNIT_ID 0

/*********************************************************
**  Configuration File Option                           **
**    if defined, then the configuration file           **
**    is invoked to read the configuratio items.        **
**    if not defined, the the configuration file is     **
**    ignored.                                          **
*********************************************************/

/*#define CONFIG_FILE			is defined by compiler arguments */

/*#define CONFIG_FILE_NAME   "runtime.cfg"*/  /* Config file name */

#define CONFIG_RDB_PATH    "RDBPath"        /* RDB directory path */
#define CONFIG_RDB_NAME    "RDBName"        /* RDB file name */

#define DEFAULT_RDB_DIR   "/aios/rdb/"      /* default rdb directory */
#define DEFAULT_RDB_NAME  "fsi_rdb.bin"     /* default rdb filename */
#define OPTIONAL_RDB_NAME "fsi_rdb%d.bin"   /* optional rdb filename */

#define CONFIG_MVAR_PATH  "MVARPath"        /* MVar table path */
#define CONFIG_MVAR_NAME  "MVARName"        /* MVar table name */
#define DEFAULT_MVAR_NAME "nav_igrf.dat"    /* Default Mvar file name */

/*********************************************************
**  Offline test enable -                               **
**    1) #define TEST in this module                    **
**    2) compile all nav modules                        **
**    3) compile and link in nav_test.c                 **
*********************************************************/

/* #define TEST */

/*********************************************************
**	Continuous Buffer Ouput Option			**
*********************************************************/
/*	Two modes of data transfer are available to 	**
**	the host: 1) Event driven, and 2) Continuous.	**
**	Defining the label BUF_CONTINUOUS activates	**
**	the continuous mode.  The default is event	**
**	driven.						**
*********************************************************/

#define BUF_CONTINUOUS

/*********************************************************
**     Commonly used structures                         **
*********************************************************/

typedef struct {
  double lat;           /* Aircraft latitude, decimal degrees */
  double lon;           /* Aircraft longitude, decimal degrees */
  float  alt;           /* Aircraft altitude, Feet MSL */
  float  thdg;          /* Aircraft true heading, degrees */
  float  pitch;         /* Aircraft pitch angle (+Up) */
  float  roll;          /* Aircraft roll angle (+Right Wing Down) */
} AC_STRUCT;

typedef struct {
  double ac_lat;        /* Aircraft latitude, decimal degrees */ 
  double ac_lon;        /* Aircraft longitude, decimal degrees */
  long   freq;          /* Receiver Frequency */
                        /* VOR, ILS, DME, TACAN, COM  => Mhz x 100 */
                        /* MLS => Channel x10 */
                        /* ADF => Khz x 10 */
  long   type;          /* Receiver Type */
                        /*  0=OFF, 1=Align, 2=VOR/ILS, 3=MLS, 4=DME, */
                        /*  5=TACAN, 6=ADF, 7=COM, 8=MKR, 9=Reserved */
                        /*  10=Reserved */
  long   bandwidth;     /* ADF Bandwidth for Analog tuning */
  char   apt_idnt[5];   /* Airport Ident (for ILS priority selection) */
  char   rwy_idnt[5];   /* Runway  Ident (for ILS priority selection) */
} RCVR_REQUEST;

typedef struct {
  char  apt_idnt[5];          /* Airport Identifier */
  char  rwy_idnt[5];          /* Runway  Identifier */
  long  rwy_sort_mode;        /* Runway Sort Mode   */
                              /* 0 = Alpha list starting with element 0 w/o duplicates in 1..n */
                              /* 1 = Longest (and lowest #) runway in element 0 w/ duplicates in 1..n */
                              /* 2 = Selected runway in element 0 w/ duplicates in 1..n */
                              /* 3 = Selected runway in element 0 w/o duplicates in 1..n */

} APTRWY_REQUEST;

typedef struct {
  double lat;                 /* Aircraft/General IP latitude */
  double lon;                 /* Aircraft/General IP longitude */
  char  ip_idnt[5];           /* IP Identifier (4chars, NULL terminated) */
  char  ip_optn[5];           /* IP Options (4chars, NULL terminated) */
  char  apt_idnt[5];          /* Airport identifer for T/O types of IP's */
} IP_REQUEST;

typedef struct {
  double lat;                 /* Aircraft/General IP latitude */
  double lon;                 /* Aircraft/General IP longitude */
  char   wx_idnt[5];          /* Facility Identifier (4chars, NULL terminated) */
} WX_REQUEST;

 
typedef struct {
  char  stn_idnt[4];          /* Kill Ident/ASCII Option */
  long  kill_optn;            /* Bitwise mask for partial kill */
  long  kill_mode;            /* Kill Mode  0= NULL, 1=Kill, 2=Reset, 3=Reset All */
  long  mkr_kill;             /* Marker Kill Option w/ ILS Kills */
} STN_KILL_REQUEST;

/*********************************************************
**	Host station buffer size definitions		**
*********************************************************/
/*  CAUTION:  The sizes of the host structs are fixed.
**  Any changed to the number of receivers, airports, wx
**  idents, etc. will require extensive modifications to the
**  nav_host communications module.
*/

#define MAX_RCVRS   25
#ifdef  CONFIG_CCC_HOST
#define MAX_AIRPORTS 1          /* max airport/runway sets */
#else
#define MAX_AIRPORTS 5          /* max airport/runway sets */
#endif
#define ILS_APT_CHK  0          /* airport to base ILS priority on */
#define MAX_KILL     9          /* max number of killed stations */
                                /* is really max number + 1	*/
#define MAX_WX       5          /* max number of radar ident searches */

/*********************************************************
**	Host Inputs (host to nav) structures		**
*********************************************************/
/*  host_cmd word is formatted as follows:		*/

/* 3|3|2|2|2|2|2|2|2|2|2|2|1|1|1|1|1|1|1|1|1|1|0|0|0|0|0|0|0|0|0|0|
** 1|0|9|8|7|6|5|4|3|2|1|0|9|8|7|6|5|4|3|2|1|0|9|8|7|6|5|4|3|2|1|0|
** -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
** <------- Spares ---------->|gmt| rwy |m|w|a|x|a|Spare|l|  rdb  |
**                            |opt| lst |k|x|d|f|n|     |o| number|
**                            | 0=| opt |r|r|f|r|v|     |a|       |
**                            |off|     |o| | | | |     |d| 0 - 5 |
**                            | 1=| 0-7 |p| | |h|o|     | |       |
**                            |YMD|     |t| | |l|n|     |r|       |
**                            | 2=|     |n| | |d| |     |d|       |
**                            |HMS|     | | | | | |     |b|       |
*/

struct command_struct {            /*Bits: (lsb=0, msb=31 )       */
  unsigned int spare1  : 14;       /*18-31 Spare bits             */
  unsigned int gmt_mode:  2;       /*16-17 GMT mode               */
                                   /*      0 = Off                */
                                   /*      1 = gmt dmyhm          */
                                   /*      2 = gmt hms            */
  unsigned int rwy_list:  3;       /*13-15 Apt/Rwy list order     */
  unsigned int mkr_kill:  1;       /*12 ils kills markers = 1     */
  unsigned int wx_srch:   1;       /*11 wx ident search mode=1    */
  unsigned int adf_mode:  1;       /*10 adf analog search=1       */
  unsigned int xfr_mode:  1;       /*9  Sun to Host xfr inhibit   */
                                   /*   1 = inhibit xfr           */
  unsigned int anytown :  1;       /*8  Anytown alignment mode    */
                                   /*   1 = Anytown mode ON       */
  unsigned int spare3  :  8;       /*5-7 Spare bits               */
};

struct host_inputs {
    long ac_lat;                        /* aircraft latitude, BAMs	*/
    long ac_lon;                        /* aircraft longitude, BAMs	*/
    char apt_idnt[MAX_AIRPORTS][4];     /* airport select ident, ASCII	*/
    char rwy_idnt[MAX_AIRPORTS][4];     /* runway  select ident, ASCII	*/
    struct command_struct host_cmd;     /* Host command	word	*/
    char ip_idnt[4];                    /* Reposition Ident, ASCII	*/
    char ip_optn[4];                    /* Reposition Option, ASCII	*/
    long stn_kill_mode;                 /* Station Facility Kill mode	*/
    char stn_kill_idnt[2][4];           /* Station kill idnt, ASCII 	*/
    long stn_kill_optn;                 /* Station Kill option, bitwise	*/
    long rcvr_freq[MAX_RCVRS];          /* Receiver Freq table		*/
    long rcvr_type[MAX_RCVRS];          /* Receiver type table		*/
    char wx_idnt[MAX_WX][4];            /* Radar ident search table	*/
};

/*********************************************************
**	Host outputs (Nav to host) structures		**
*********************************************************/

/**    radio facility structure  **/
/**    structure      dbp label		host label   */

typedef struct stn_struct{
  char   idnt[4];     /* NSTNIDNT  I*4 ASCII	*/
  char   icao[4];     /* NSTNICAO  I*4 ASCII	*/
  long   typ1;        /* NSTNTYP   I*4 Bits	*/
  long   typ2;        /* NSTN2TYP  I*4 Bits	*/
  float  rng ;        /* NSTNRNG   R*4 Nm.	*/
  double lat ;        /* NSTNLAT   R*8 Degr.	*/
  double lon ;        /* NSTNLON   R*8 Degr.	*/
  float  var ;        /* NSTNVAR   R*4 Deg	*/
  float  elv ;        /* NSTNELV   R*4 Feet MSL*/
  long   frq ;        /* NSTNFRQ   I*4 Mhz x 100*/
                      /*               Khz x 10*/
                      /*               Channel x10*/
  float  hdg ;        /* NSTNHDG   R*4 Degr.	*/
  char   aid[4];      /* NSTNAID   I*4 ASCII	*/
  char   rid[4];      /* NSTNRID   I*4 ASCII	*/
  float  lgd ;        /* NSTNLGD   I*4 Feet	*/
  float  lbw ;        /* NSTNLBW   R*4 Degr.	*/
  float  gsa ;        /* NSTNGSA   R*4 Degr.	*/
  float  gsw ;        /* NSTNGSW   R*4 Degr.	*/
  long   gtd ;        /* NSTNGTD   I*4 Feet.	*/
  float  bad ;        /* NSTNBAD   R*4 Ft.	*/
  float  apal;        /* NSTNAPAL  R*4 Degr.	*/
  float  apar;        /* NSTNAPAR  R*4 Degr.	*/
  float  acal;        /* NSTNACAL  R*4 Degr.	*/
  float  acar;        /* NSTNACAR  R*4 Degr	*/
  float  mgpa;        /* NSTNMGPA  R*4 Degr.	*/
  float  bpal;        /* NSTNBPAL  R*4 Degr.	*/
  float  bpar;        /* NSTNBPAR  R*4 Degr.	*/
  float  bpcl;        /* NSTNBPCL  R*4 Degr.	*/
  float  bpcr;        /* NSTNBPCR  R*4 Degr.	*/
  float  bhdg;        /* NSTNBHDG  R*4 Degr.	*/
} STN_STRUCT;

/***   structure    dbp label           host label  */

typedef struct rwy_struct{
  char   idnt[4];    /* NRWYIDNT  I*4 ASCII	*/
  char   icao[4];    /* NRWYICAO  I*4 ASCII	*/
  long   typ1;       /* NRWYTYP   I*4 Bits	*/
  long   typ2;       /* NRWY2TYP  I*4 Bits	*/
  float  hdg;        /* NRWYHDG   R*4 Degr.	*/
  double lat;		/* NRWYLAT   R*8 Degr.	*/
  double lon;		/* NRWYLON   R*8 Degr.	*/
  float  len;		/* NRWYLEN   R*4 Feet	*/
  float  dtr;		/* NRWYDTR   R*4 Feet	*/
  float  wid;		/* NRWYWID   R*4 Feet	*/
  char   lid[4];     /* NRWYLID   I*4 ASCII	*/
  char   aid[4];     /* NRWYAID   I*4 ASCII	*/
  long   ifrq;       /* NRWYIFRQ  i*4 Mhz*100*/
  long   afrq[3];    /* NRWYU1FQ  I*4 Mhz*100*/
} RWY_STRUCT;

typedef struct apt_struct{
  char   idnt[4];    /* NAPTIDNT  I*4 ASCII	*/
  char   icao[4];    /* NAPTICAO  I*4 ASCII	*/
  char   ata[4];     /* NAPT2IDT  I*4 ASCII	*/
  long   typ1;       /* NAPTTYP   I*4 Bits	*/
  long   typ2;       /* NAPT2TYP  I*4 Bits	*/
  double lat;        /* NAPTLAT   R*8 Degr.	*/
  double lon;        /* NAPTLON   R*8 Degr.	*/
  float  var;        /* NAPTVAR   R*4 Degr.	*/
  float  elv;        /* NAPTELV   R*4 Feet	*/
  char   name[32];   /* NAPTNAME  I*4(8)ASCII*/
  char   rwy[20][4]; /* NAPTRWY   I*4(20)ASCII*/
} APT_STRUCT;

typedef struct ip_struct{
  char   idnt[4];    /* NSIPIDNT  I*4 ASCII	*/
  char   optn[4];    /* NSIPOPTN  I*4 ASCII	*/
  double slat;       /* NSIPSLAT  R*8 Deg.	*/
  double slon;       /* NSIPSLON  R*8 Deg.	*/
  double mlat;       /* NSIPMLAT  R*8 Degr.	*/
  double mlon;       /* NSIPMLON  R*8 Degr.	*/
  long   typ1;       /* NSIPTYP1  I*4	*/
  long   typ2;       /* NSIPTYP2  I*4	*/
  float  var;        /* NSIPVAR   R*4 deg	*/
  float  elv;        /* NSIPELV   R*4 feet	*/
  float  hdg;        /* NSIPHDG   R*4 Deg.	*/
  float  lgd;        /* NSIPLGD   R*4 Feet	*/
  float  gsa;        /* NSIPGSA   R*4 Degr.	*/
} IP_STRUCT;

typedef struct wx_struct{
  double lat;        /* NQSTNLAT  R*8 Deg.	*/
  double lon;        /* NQSTNLON  R*8 Deg.	*/
  float  elv;        /* NQSTNELV  R*8 Ft. MSL*/
  char   idnt[4];    /* NQSTNIDT  I*4 ASCII	*/
} WX_STRUCT;


struct host_outputs {
  float elv;                       /* elevation, ft   */
  float var;                       /* variation, deg  */
  long  count;                     /* xfr counter     */
  STN_STRUCT stn[MAX_RCVRS];       /* receiver buffers*/
  APT_STRUCT apt[MAX_AIRPORTS];    /* airport buffer  */
  RWY_STRUCT rwy[MAX_AIRPORTS];    /* runway  buffer  */
  IP_STRUCT  ip;                   /* reposition buffer*/
  WX_STRUCT  wx[MAX_WX];           /* radar ident buffer*/
};

/*********************************************************
**	Module communication structures			**
*********************************************************/

typedef struct kill_tbl_struct{ 
  char idnt[4]; long mask;
} KILL_TBL_STRUCT;

/*********************************************************
**	Commonly used macro & declarations		**
*********************************************************/

#include <math.h>
#define BAMS16(D) (short)( (float )(D) * 182.0444444   )
#define BAMS32(D) (long )( (double)(D) * 11930464.71   )
#define DEGR16(B)        ( (float )(B) * 0.005493164   )
#define DEGR32(B)        ( (double)(B) * 8.38190312e-8 )
#define BAM32_TO_RAD 1.4629E-09
#define FEET_TO_DEG 0.2741e-5	/* (1deg/60nm)*(1nm/6080ft) */
#define DEG_TO_RAD  0.017453292	/* PI/180.0	*/
#define RAD_TO_DEG 57.295779513	/* 180.0/PI	*/
#define abs(val)  ( (val)<0 ? -(val): (val) )	/*absoloute value*/
#define NORM180(D)  ( ((D)>180.0)?((D)-360.0):(((D)<-180.0)?((D)+360.0):(D)))
#define NORM360(D)  ( ((D)>360.0)?((D)-360.0):(((D)<0.0)?((D)+360.0):(D)))
#define LIMIT(V,MX,MN) ( ((V)>MX)?(MX):(((V)<MN)?(MN):(V)) )

#endif
/******* end of navdef.h  *******/
