/*****************************************************************
**                                                              **
**  FlightSafety International, Inc.                            **
**  2700 North Hemlock Circle                                   **
**  Broken Arrow, Oklahoma 74012                                **
**  (918) 251-0500                                              **
**                                                              **
******************************************************************
**                                                              **
**  The information contained herein is the property of         **
**  FlightSafety Simulation Systems Division and shall          **
**  not be copied or used in any manner or disclosed to         **
**  others execpt as expressly authorized by FSI-SSD.           **
**                                                              **
******************************************************************
**                                                              **
**  Department:  Navigation/Visual (65)                         **
**                                                              **
**  Task:        Radio Database Search Engine                   **
**               Global Definitions                             **
**  Author:      Terry Tyler                                    **
**                                                              **
**  Revision:    1.18                Date: 10/Dec/97            **
**  Revised by:  T.Tyler                                        **
**                                                              **
*****************************************************************/

/*****************************************************************
**  Program Description:                                        **
*****************************************************************/
/*  The nav_global.h contains all the global defintions used
**  in the nav tasks.
*/

/*****************************************************************
*  Revision History
******************************************************************
*
* $Id:  $
* $Log:  $ 
*
*****************************************************************/


/*****************************************************************
**  Revision History:                                           **
*****************************************************************/


#ifndef NAV_GLOBAL_H
#define NAV_GLOBAL_H

#include "nav_navdef.h"
#include "nav_rdbdef.h"

#ifdef GLOBAL_DEF
#define GLOBAL
#define G_INIT      =0
#else
#define GLOBAL extern
#define G_INIT
#endif

/***  Radio Database  ***/

GLOBAL RDB *rdb G_INIT;

/***  Radio Database Table Structures  ***/

GLOBAL RDB_IDX_TBL frq_tbl;
GLOBAL RDB_IDX_TBL idt_tbl;
GLOBAL RDB_IDX_TBL lat_tbl;

/***  Host Input/Output Buffers  ***/

GLOBAL struct host_inputs host_in;
GLOBAL struct host_outputs host_out;

/***  Station Kill Tables and Variables  ***/

GLOBAL KILL_TBL_STRUCT stn_kill_table[MAX_KILL];
GLOBAL long   stn_kill_active G_INIT;

#endif
