-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package allows clients to record descriptions of events without having
-- to wait for the output to be performed.
--
-- Theme Song: What rolls down stairs, alone or in pairs
--             and flattens the neighbor's dog?
--             What's great for a snack, and fits on your back?
--             It's log log LOG!
--             It's log; it's log. It's big; it's heavy; it's wood.
--             It's log; it's log. It's better than bad; it's good!
-------------------------------------------------------------------------------
package Log is

   -- The severity level of the event. This will be printed out with the event.
   type Event_Type is (Informational, Warning, Error, Fatal);

   ----------------------------------------------------------------------------
   -- Report an event to the log. The logger (see body) will output the event
   -- along with the severity and time-stamp as soon as it can. If the logger
   -- gets behind it is possible that new reports will dropped.
   ----------------------------------------------------------------------------
   procedure Report (Event    : in String;
                     Severity : in Event_Type := Informational);

   ----------------------------------------------------------------------------
   -- Wait for all pending log entries to be serviced.
   -- The log is processed by a background (default) priority task. That means
   -- a higher priority task that sends a message to the log will not have its
   -- message processed until that task ceases all activity. That's generally
   -- desirable behavior. But if a high priority task wants to send a status
   -- message to explain long processing delays (eg: during initialization),
   -- it is desirable to allow the log message to be processed before it
   -- proceeds with its work. This routine allows for that.
   ----------------------------------------------------------------------------
   procedure Wait;

end Log;
