-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- A simple acquire/release lock. This may be used as a simple, fast building
-- block for more complicated task synchronization constructs.
--
-- Note that there is no protection from a task releasing a lock it does not
-- own. This should be avoided procedurally for obvious reasons.
-------------------------------------------------------------------------------
package body Lock is

   protected body Instance is

      ----------------------------------------------------------------------------
      -- Attempt to acquire the lock. The entry will not be accepted until the
      -- lock is available (released).
      ----------------------------------------------------------------------------
      entry Acquire when not Locked or (Loaning and not Lent) is
      begin
         if Loaning then
            Lent := True;
         else
            Locked := True;
         end if;
      end Acquire;

      ----------------------------------------------------------------------------
      -- Release an acqured lock.
      ----------------------------------------------------------------------------
      procedure Release is
      begin
         -- either way, the lock is no longer on loan
         Loaning := False;

         if Lent then
            Lent   := False;
         else
            Locked := False;
         end if;
      end Release;

      ----------------------------------------------------------------------------
      -- Allow the next requestor to acquire the lock and proceed. The owner still
      -- has the lock as well, so it must still be released.
      ----------------------------------------------------------------------------
      procedure Loan is
      begin
         Loaning := True;
      end Loan;

      ----------------------------------------------------------------------------
      -- Allow the next requestor to acquire the lock and proceed. Holds the
      -- caller until the next requestor has called Release. Retake should *not*
      -- be called after this. The caller still has the lock as well, so it must
      -- still be released.
      ----------------------------------------------------------------------------
      entry Loan_Wait when True is
      begin
         Loaning := True;
         requeue Wait_For_Loan_Release;
      end Loan_Wait;

      ----------------------------------------------------------------------------
      -- Retake a granted lock. If someone else is using it, wait for them to
      -- release.
      ----------------------------------------------------------------------------
      entry Retake when not Lent is
      begin
         Loaning := False;
      end Retake;

      entry Wait_For_Loan_Release when not Loaning is
      begin
         null;
      end Wait_For_Loan_Release;

   end Instance;

end Lock;

