
-- function body

function Limit_G
  (Value : in Value_Type)
   return Limit_Type is 

   Limited_Value : Limit_Type;

begin

   -- if below the floor of the limiting type
   if Value < Value_Type(Limit_Type'First) then 
      Limited_Value := Limit_Type'First;
      
   -- if above the ceiling of the limiting type
   elsif Value > Value_Type(Limit_Type'Last) then
      Limited_Value := Limit_Type'Last;

   -- if within the range, make no change 
   else 
      Limited_Value := Limit_Type(Value);
   end if;
   
   return Limited_Value;

end Limit_G;
