-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
-- 
--
--  Engineer:  Michael D. Bates
-- 
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- Generic function to limit a floating point value of Value_Type to
-- the range of values permitted by Limit_Type.

generic
   
   type Value_Type is digits <>;
   -- input floating point type
   
   type Limit_Type is digits <>;
   -- limiting floating point type
   
function Limit_G
  (Value : in Value_Type)
   return Limit_Type;

-- function body

function Limit_G
  (Value : in Value_Type)
   return Limit_Type is 

   Limited_Value : Limit_Type;

begin

   -- if below the floor of the limiting type
   if Value < Value_Type(Limit_Type'First) then 
      Limited_Value := Limit_Type'First;
      
   -- if above the ceiling of the limiting type
   elsif Value > Value_Type(Limit_Type'Last) then
      Limited_Value := Limit_Type'Last;

   -- if within the range, make no change 
   else 
      Limited_Value := Limit_Type(Value);
   end if;
   
   return Limited_Value;

end Limit_G;
