-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

package Length_Types is
   subtype Feet              is Float;
   subtype Sq_Feet           is Float;
   subtype Cubic_Feet        is Float;
   subtype Meters            is Float;
   subtype Sq_Meters         is Float;
   subtype Cubic_Meters      is Float;
   subtype Inches            is Float;
   subtype Sq_Inches         is Float;
   subtype Cubic_Inches      is Float;

   subtype Feet_per_Sec      is Float;
   subtype Feet_per_Min      is Float;
   subtype Inches_Per_Sec    is Float;
   subtype Inches_Per_Min    is Float;
   subtype Knots             is Float;
   subtype Mach              is Float;

   subtype Feet_Per_Sec_Sq   is Float;
   subtype Inches_Per_Sec_Sq is Float;

   subtype Gallons           is Float;
   subtype Gph               is Float;  -- gallons per hour
   subtype Gpm               is Float;  -- gallons per minute
   subtype Gps               is Float;  -- gallons per second

   function Feet_Per_Sec_To_Knots (Fps : in Feet_Per_Sec) return Knots;
   function Knots_To_Feet_Per_Sec (Kts : in Knots ) return Feet_Per_Sec;

end Length_Types;

