-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


package body Length_Types is

   ---------------------------
   -- Feet_Per_Sec_To_Knots --
   ---------------------------

   function Feet_Per_Sec_To_Knots (Fps : in Feet_Per_Sec) return Knots is
   begin
      return Knots(Float(Fps)*0.592_09);
   end Feet_Per_Sec_To_Knots;

   ---------------------------
   -- Knots_To_Feet_Per_Sec --
   ---------------------------

   function Knots_To_Feet_Per_Sec (Kts : in Knots) return Feet_Per_Sec is
   begin
      return Feet_Per_Sec(Float(Kts)*1.689_323_85);
   end Knots_To_Feet_Per_Sec;

end Length_Types;

