-------------------------------------------------------------------------------
--| 
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--| 
--|                  JPATS T-6A Texan-II Flight Training Device
--|  
--| 
--|   Engineer:  Yogesh Tupe
--|  
--|   Revision:  (Number and date inserted by Clearcase)
--| 
--| 
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--| 
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--| 
-------------------------------------------------------------------------------
--| 

package body Integration_G is
--    
    function Predictor (A_Last_Pass_Variable                   :in Variable_Type; 
                        A_Ist_Derivative_of_Variable           :in Variable_Type; 
                        A_Last_Pass_Ist_Derivative_of_Variable :in Variable_Type;
                        An_Integration_Constant                :in Variable_Type) return Variable_Type is
        A_New_Variable : Variable_Type;
    begin
        A_New_Variable := A_Last_Pass_Variable + An_Integration_Constant 
                                                  * (1.5 * A_Ist_Derivative_of_Variable
                                                     - 0.5 * A_Last_Pass_Ist_Derivative_of_Variable);
        return A_New_Variable;
    end Predictor;
--    
--__________________________________________________________________________________________________________ 
--                           
    function Corrector (A_Last_Pass_Variable                   :in Variable_Type; 
                        A_Ist_Derivative_of_Variable           :in Variable_Type; 
                        A_Last_Pass_Ist_Derivative_of_Variable :in Variable_Type;
                        An_Integration_Constant                :in Variable_Type) return Variable_Type is
        A_New_Variable : Variable_Type;
    begin
        A_New_Variable := A_Last_Pass_Variable + An_Integration_Constant 
                                               * 0.5 * (A_Ist_Derivative_of_Variable
                                                        + A_Last_Pass_Ist_Derivative_of_Variable);
        return A_New_Variable;
    end Corrector;
--    
--__________________________________________________________________________________________________________ 
--                               
end Integration_G;

