-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Real_Time;

-------------------------------------------------------------------------------
-- This package provides high-resolution timing under vxWorks. Even
-- Ada.Real_Time can only provide a resolution equal to the clock frequency.
-------------------------------------------------------------------------------
package High_Resolution_Timer is

   type Instance is private;

   ----------------------------------------------------------------------------
   -- Start a timer.
   ----------------------------------------------------------------------------
   procedure Start (Timer : out Instance);

   ----------------------------------------------------------------------------
   -- Stop a previously started timer.
   ----------------------------------------------------------------------------
   procedure Stop (Timer : in out Instance);

   ----------------------------------------------------------------------------
   -- Return the amount of milliseconds that elapsed while the timer was
   -- running.
   ----------------------------------------------------------------------------
   function Milliseconds (Timer : Instance) return Float;

private
   type Time_Stamp is mod 2**32;

   type Time_Descriptor is record
     Time  : Ada.Real_Time.Time;
     Stamp : Time_Stamp;
   end record;

   type Instance is record
      Start : Time_Descriptor;
      Stop  : Time_Descriptor;
   end record;

end High_Resolution_Timer;

