-- Copyright (C) 1994-1998 Grady Booch and Simon Wright.
-- All Rights Reserved.
--
--      This program is free software; you can redistribute it
--      and/or modify it under the terms of the Ada Community
--      License which comes with this Library.
--
--      This program is distributed in the hope that it will be
--      useful, but WITHOUT ANY WARRANTY; without even the implied
--      warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
--      PURPOSE. See the Ada Community License for more details.
--      You should have received a copy of the Ada Community
--      License with this library, in the file named "Ada Community
--      License" or "ACL". If not, contact the author of this library
--      for a copy.
--

-- $Id: smart_test_support.ads,v 1.2 1999/04/10 14:38:23 simon Exp $

with Ada.Finalization;
with BC.Smart;

package Smart_Test_Support is

  -- This type is used to test BC.Smart. It's Controlled simply so that we
  -- can see when instances are deleted.
  type T is new Ada.Finalization.Controlled with record
    C : Character;
  end record;
  type P is access T;

  procedure Finalize (The_T : in out T);

  package Smart is new BC.Smart (T => T, P => P);

  function Create (Ch : Character) return Smart.Pointer;
  function Value (P : Smart.Pointer) return Character;

end Smart_Test_Support;
