-- Copyright (C) 1994-1999 Grady Booch and Simon Wright.
-- All Rights Reserved.
--
--      This program is free software; you can redistribute it
--      and/or modify it under the terms of the Ada Community
--      License which comes with this Library.
--
--      This program is distributed in the hope that it will be
--      useful, but WITHOUT ANY WARRANTY; without even the implied
--      warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
--      PURPOSE. See the Ada Community License for more details.
--      You should have received a copy of the Ada Community
--      License with this library, in the file named "Ada Community
--      License" or "ACL". If not, contact the author of this library
--      for a copy.
--

-- $Id: bc-containers-trees-binary-post_order.adb,v 1.2 1999/04/10 14:38:20 simon Exp $

procedure BC.Containers.Trees.Binary.Post_Order
   (T : Binary_Tree; Success : out Boolean) is
  Subtree : Binary_Tree;
  Result : Boolean;
begin
  Success := True;
  if not Is_Null (T) then
    Subtree := T;
    Left_Child (Subtree);
    Post_Order (Subtree, Result);
    if not Result then
      Success := False;
      return;
    end if;
    Subtree := T;
    Right_Child (Subtree);
    Post_Order (Subtree, Result);
    if not Result then
      Success := False;
      return;
    end if;
    Apply (T.Rep.Element, Result);
    if not Result then
      Success := False;
      return;
    end if;
  end if;
end BC.Containers.Trees.Binary.Post_Order;

