-- Copyright (C) 1994-1999 Grady Booch and Simon Wright.
-- All Rights Reserved.
--
--      This program is free software; you can redistribute it
--      and/or modify it under the terms of the Ada Community
--      License which comes with this Library.
--
--      This program is distributed in the hope that it will be
--      useful, but WITHOUT ANY WARRANTY; without even the implied
--      warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
--      PURPOSE. See the Ada Community License for more details.
--      You should have received a copy of the Ada Community
--      License with this library, in the file named "Ada Community
--      License" or "ACL". If not, contact the author of this library
--      for a copy.
--

-- $Id: bc-containers-rings-unbounded-guarded.ads,v 1.1.2.1 1999/05/02 20:03:25 simon Exp $

with BC.Support.Synchronization;

generic
  type Semaphore is new BC.Support.Synchronization.Semaphore_Base with private;
package BC.Containers.Rings.Unbounded.Guarded is

  type Guarded_Unbounded_Ring is new Unbounded_Ring with private;

  function "=" (Left, Right : in Guarded_Unbounded_Ring) return Boolean;

  procedure Seize (R : in out Guarded_Unbounded_Ring);

  procedure Release (R : in out Guarded_Unbounded_Ring);

private

  type Guarded_Unbounded_Ring is new Unbounded_Ring with record
    Guard : BC.Support.Synchronization.Semaphore_P;
  end record;

  procedure Initialize (R : in out Guarded_Unbounded_Ring);
  procedure Adjust (R : in out Guarded_Unbounded_Ring);
  procedure Finalize (R : in out Guarded_Unbounded_Ring);

end BC.Containers.Rings.Unbounded.Guarded;
