-- Copyright (C) 1994-1999 Grady Booch and Simon Wright.
-- All Rights Reserved.
--
--      This program is free software; you can redistribute it
--      and/or modify it under the terms of the Ada Community
--      License which comes with this Library.
--
--      This program is distributed in the hope that it will be
--      useful, but WITHOUT ANY WARRANTY; without even the implied
--      warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
--      PURPOSE. See the Ada Community License for more details.
--      You should have received a copy of the Ada Community
--      License with this library, in the file named "Ada Community
--      License" or "ACL". If not, contact the author of this library
--      for a copy.
--

-- $Id: bc-containers-rings-unbounded-guarded.adb,v 1.1.2.1 1999/05/02 20:03:25 simon Exp $

package body BC.Containers.Rings.Unbounded.Guarded is

  function "=" (Left, Right : in Guarded_Unbounded_Ring) return Boolean is
  begin
    return "=" (Unbounded_Ring (Left), Unbounded_Ring (Right));
  end "=";

  procedure Seize (R : in out Guarded_Unbounded_Ring) is
  begin
    BC.Support.Synchronization.Seize (R.Guard.all);
  end Seize;

  procedure Release (R : in out Guarded_Unbounded_Ring) is
  begin
    BC.Support.Synchronization.Release (R.Guard.all);
  end Release;

  procedure Initialize (R : in out Guarded_Unbounded_Ring) is
  begin
    Initialize (Unbounded_Ring (R));
    R.Guard := new Semaphore;
  end Initialize;

  procedure Adjust (R : in out Guarded_Unbounded_Ring) is
    -- Consider R := P;
    -- On entry to Adjust, R contains a bitwise copy of P.
  begin
    -- lock P's semaphore
    Seize (R);
    -- make the deep copy
    Adjust (Unbounded_Ring (R));
    -- unlock P's semaphore
    Release (R);
    -- create a new semaphore for R
    R.Guard := new Semaphore;
  end Adjust;
  -- XXX Perhaps Adjust should use a lock variable? to ensure it's
  -- released even if an exception occurs.

  procedure Finalize (R : in out Guarded_Unbounded_Ring) is
  begin
    BC.Support.Synchronization.Delete (R.Guard);
    Finalize (Unbounded_Ring (R));
  end Finalize;

end BC.Containers.Rings.Unbounded.Guarded;
