-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics;

package Angle_Types is
   subtype Radians             is Float;
   subtype Radians_per_Sec     is Float;
   subtype Radians_per_Sq_Sec  is Float;

   subtype Degrees             is Float;
   subtype Degrees_per_Sec     is Float;
   subtype Degrees_per_Sq_Sec  is Float;
   subtype Normalized_180      is Float range -180.0..180.0;
   subtype Normalized_360      is Float range 0.0..360.0;

   subtype Revolutions         is Float; -- Revolutions
   subtype Revolutions_Per_Sec is Float; -- Revolutions per second
   subtype Rpm                 is Float; -- Revolutions per minute
   subtype Rpm_Per_Sec         is Float; -- Revolutions per minute per second


   function Degrees_To_Radians ( Angle : in Degrees ) return Radians;
   function Radians_To_Degrees ( Angle : in Radians ) return Degrees;
   function Degrees_To_Revolutions ( Angle : in Degrees) return Revolutions;
   function Radians_To_Revolutions ( Angle : in Radians) return Revolutions;
   function Revolutions_To_Degrees ( Angle : in Revolutions ) return Degrees;
   function Revolutions_To_Radians ( Angle : in Revolutions ) return Radians;

   function Rpm_To_Radians_Per_Sec( X : in Rpm) return Radians_Per_Sec;
   function Rpm_To_Degrees_Per_Sec( X : in Rpm) return Degrees_Per_Sec;
   function Radians_Per_Sec_To_Rpm( X : in Radians_Per_Sec) return Rpm;
   function Radians_Per_Sec_To_Degrees_Per_Sec ( X : in Radians_Per_Sec ) return Degrees_Per_Sec;
   function Degrees_Per_Sec_To_Rpm( X : in Degrees_Per_Sec) return Rpm;
   function Degrees_Per_Sec_To_Radians_Per_Sec ( X : in Degrees_Per_Sec ) return Radians_Per_Sec;

   function Rpm_Per_Sec_To_Radians_Per_Sq_Sec( X : in Rpm_Per_Sec) return Radians_Per_Sq_Sec;
   function Rpm_Per_Sec_To_Degrees_Per_Sq_Sec( X : in Rpm_Per_Sec) return Degrees_Per_Sq_Sec;
   function Radians_Per_Sq_Sec_To_Rpm_Per_Sec( X : in Radians_Per_Sq_Sec) return Rpm_Per_Sec;
   function Radians_Per_Sq_Sec_To_Degrees_Per_Sq_Sec ( X : in Radians_Per_Sq_Sec ) return Degrees_Per_Sq_Sec;
   function Degrees_Per_Sq_Sec_To_Rpm_Per_Sec( X : in Degrees_Per_Sq_Sec) return Rpm_Per_Sec;
   function Degrees_Per_Sq_Sec_To_Radians_Per_Sq_Sec ( X : in Degrees_Per_Sq_Sec ) return Radians_Per_Sq_Sec;

   -------------------------------------------------------------------------------
   -- Normalization routines. This returns the given amount in degrees normailzed
   -- into the specified range.
   -------------------------------------------------------------------------------
   function Normalize_Degrees_180 ( Unnormalized_Degrees : in Degrees) return Normalized_180;
   function Normalize_Degrees_360 ( Unnormalized_Degrees : in Degrees) return Normalized_360;
end Angle_Types;




