-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Numerics;

package body Angle_Types is

   ------------------------
   -- Degrees_To_Radians --
   ------------------------

   function Degrees_To_Radians (Angle : in Degrees) return Radians is
   begin
      return Radians(Float(Angle)*Ada.Numerics.Pi/180.0);
   end Degrees_To_Radians;

   ------------------------
   -- Radians_To_Degrees --
   ------------------------

   function Radians_To_Degrees (Angle : in Radians) return Degrees is
   begin
      return Degrees(Float(Angle)*180.0/Ada.Numerics.Pi);
   end Radians_To_Degrees;

   ----------------------------
   -- Degrees_To_Revolutions --
   ----------------------------

   Function Degrees_To_Revolutions (Angle : in Degrees) return Revolutions is
   begin
      return Revolutions(Float(Angle)/360.0);
   end;

   ----------------------------
   -- Radians_To_Revolutions --
   ----------------------------

   Function Radians_To_Revolutions (Angle : in Radians) return Revolutions is
   begin
      return Revolutions(Float(Angle)/(2.0*Ada.Numerics.Pi));
   end;

   ----------------------------
   -- Revolutions_to_Degrees --
   ----------------------------

   Function Revolutions_To_Degrees ( Angle : in Revolutions ) return Degrees is
   begin
      return Degrees(Float(Angle)*360.0);
   end;

   ----------------------------
   -- Revolutions_to_Radians --
   ----------------------------

   Function Revolutions_To_Radians ( Angle : in Revolutions ) return Radians is
   begin
      return Radians(Float(Angle)*2.0*Ada.Numerics.Pi);
   end;

   ----------------------------
   -- Rpm_To_Degrees_Per_Sec --
   ----------------------------

   function Rpm_To_Degrees_Per_Sec (X : in Rpm) return Degrees_Per_Sec is
   begin
      return Degrees_Per_Sec(Float(X)*360.0/60.0);
   end Rpm_To_Degrees_Per_Sec;

   ----------------------------
   -- Rpm_To_Radians_Per_Sec --
   ----------------------------

   function Rpm_To_Radians_Per_Sec (X : in Rpm) return Radians_Per_Sec is
   begin
      return Radians_Per_Sec(Float(X)*2.0*Ada.Numerics.Pi/60.0);
   end Rpm_To_Radians_Per_Sec;

   ----------------------------
   -- Radians_Per_Sec_To_Rpm --
   ----------------------------

   function Radians_Per_Sec_To_Rpm (X : in Radians_Per_Sec) return Rpm is
   begin
      return Rpm(Float(X)*60.0/(2.0*Ada.Numerics.Pi));
   end Radians_Per_Sec_To_Rpm;

   ----------------------------------------
   -- Radians_per_sec_To_Degrees_per_sec --
   ----------------------------------------

   function Radians_Per_Sec_To_Degrees_Per_Sec  ( X : in Radians_Per_Sec) return Degrees_Per_Sec  is
   begin
      return Degrees_Per_Sec(Float(X)*180.0/Ada.Numerics.Pi);
   end Radians_Per_Sec_To_Degrees_Per_Sec;

   ----------------------------
   -- Degrees_Per_Sec_To_Rpm --
   ----------------------------

   function Degrees_Per_Sec_To_Rpm (X : in Degrees_Per_Sec) return Rpm is
   begin
      return Rpm(Float(X)/360.0*60.0);
   end Degrees_Per_Sec_To_Rpm;


   ----------------------------------------
   -- Degrees_per_sec_To_Radians_per_sec --
   ----------------------------------------

   function Degrees_Per_Sec_To_Radians_Per_Sec ( X : in Degrees_Per_Sec) return Radians_Per_Sec is
   begin
      return Radians_Per_sec(Float(X)*Ada.Numerics.Pi/180.0);
   end Degrees_Per_Sec_To_Radians_Per_Sec;

   ---------------------------------------
   -- Rpm_Per_sec_To_Degrees_Per_Sq_Sec --
   ---------------------------------------

   function Rpm_Per_Sec_To_Degrees_Per_Sq_Sec (X : in Rpm_Per_Sec) return Degrees_Per_Sq_Sec is
   begin
      return Degrees_Per_Sq_Sec(Float(X)*360.0/60.0);
   end Rpm_Per_Sec_To_Degrees_Per_Sq_Sec;

   ---------------------------------------
   -- Rpm_per_sec_To_Radians_Per_sq_Sec --
   ---------------------------------------

   function Rpm_Per_Sec_To_Radians_Per_Sq_Sec (X : in Rpm_Per_Sec) return Radians_Per_Sq_Sec is
   begin
      return Radians_Per_Sq_Sec(Float(X)*2.0*Ada.Numerics.Pi/60.0);
   end Rpm_Per_Sec_To_Radians_Per_Sq_Sec;

   ---------------------------------------
   -- Radians_Per_Sq_Sec_To_Rpm_Per_Sec --
   ---------------------------------------

   function Radians_Per_Sq_Sec_To_Rpm_Per_Sec (X : in Radians_Per_Sq_Sec) return Rpm_Per_Sec is
   begin
      return Rpm_Per_Sec(Float(X)*60.0/(2.0*Ada.Numerics.Pi));
   end Radians_Per_Sq_Sec_To_Rpm_Per_Sec;

   ----------------------------------------
   -- Radians_per_sq_sec_To_Degrees_per_sq_sec --
   ----------------------------------------

   function Radians_Per_Sq_Sec_To_Degrees_Per_Sq_Sec  ( X : in Radians_Per_Sq_Sec) return Degrees_Per_Sq_Sec  is
   begin
      return Degrees_Per_Sq_Sec(Float(X)*180.0/Ada.Numerics.Pi);
   end Radians_Per_Sq_Sec_To_Degrees_Per_Sq_Sec;

   ---------------------------------------
   -- Degrees_Per_Sq_Sec_To_Rpm_Per_Sec --
   ---------------------------------------

   function Degrees_Per_Sq_Sec_To_Rpm_Per_Sec (X : in Degrees_Per_Sq_Sec) return Rpm_Per_Sec is
   begin
      return Rpm_Per_Sec(Float(X)/360.0*60.0);
   end Degrees_Per_Sq_Sec_To_Rpm_Per_Sec;


   ----------------------------------------------
   -- Degrees_per_sq_sec_To_Radians_per_sq_sec --
   ----------------------------------------------

   function Degrees_Per_Sq_Sec_To_Radians_Per_Sq_Sec ( X : in Degrees_Per_Sq_Sec) return Radians_Per_Sq_Sec is
   begin
      return Radians_per_sq_sec(Float(X)*Ada.Numerics.Pi/180.0);
   end Degrees_Per_Sq_Sec_To_Radians_Per_Sq_Sec;


   -------------------------------------------------------------------------------
   -- Normalization routines. This returns the given amount in degrees normailzed
   -- into the specified range.
   -------------------------------------------------------------------------------
   function Normalize_Degrees_360 ( Unnormalized_Degrees : in Degrees) return Normalized_360 is
      Scale : constant Float := Float'Floor(Unnormalized_Degrees / 360.0);
   begin
      return Unnormalized_Degrees - (Scale * 360.0);
   end Normalize_Degrees_360;

   function Normalize_Degrees_180 ( Unnormalized_Degrees : in Degrees) return Normalized_180 is
      Scale : constant Float := Float'Rounding(Unnormalized_Degrees / 360.0);
   begin
      return Unnormalized_Degrees - (Scale * 360.0);
   end Normalize_Degrees_180;

end Angle_Types;


