-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Reposition_Types,
  Jpats_Radio_Db_If_Types;

package Reposition is

   package Jrt renames Jpats_Reposition_Types;

   type Ramp_Type is private;

   type Holdshort_Type is private;

   type Ramp_Access is access Ramp_Type;

   type Holdshort_Access is access Holdshort_Type;

   --for relative repositions using ILS information
   procedure Relative
     (Ref_Lat : in     Jrt.Lat_Type;
      Ref_Lon : in     Jrt.Lon_Type;
      Ref_Lgd : in     Float;
      Ref_Hdg : in     Jrt.Bearing_Type;
      Ref_Gsa : in     Float;
      Ref_Alt : in     Float;
      Ref_Sel : in     Jrt.Reposition_Select_Type;
      Command : in out Jrt.Reposition_Command_Type);

   --for relative repositions using runway information
   procedure Relative
     (Ref_Lat : in     Jrt.Lat_Type;
      Ref_Lon : in     Jrt.Lon_Type;
      Ref_Hdg : in     Jrt.Bearing_Type;
      Ref_Alt : in     Float;
      Ref_Sel : in     Jrt.Reposition_Select_Type;
      Command : in out Jrt.Reposition_Command_Type);

   --for ramp repositions based upon active airport
   procedure Ramp
     (Ref_Apt : in     Jpats_Radio_Db_If_Types.Output_Ident;
      Command : in out Jrt.Reposition_Command_Type);

   --for formation repositions based upon formation position, etc.
   procedure Formation
     (Ref_Lat     : in     Jrt.Lat_Type;
      Ref_Lon     : in     Jrt.Lon_Type;
      Ref_Alt     : in     Float;
      Ref_Hdg     : in     Jrt.Bearing_Type;
      Ref_Ias     : in     Float;
      Fore_Aft    : in     Float;
      Left_Right  : in     Float;
      Above_Below : in     Float;
      Command     : in out Jrt.Reposition_Command_Type);

   --for hold short repositions based upon active airport
   procedure Holdshort
     (Ref_Apt : in     Jpats_Radio_Db_If_Types.Output_Ident;
      Ref_Rwy : in     Jrt.String4;
      Command : in out Jrt.Reposition_Command_Type);

   procedure Initialize_Ramp_List;

   procedure Initialize_Holdshort_List;
   
   procedure Capture_Ramp(
         Airport  : in Jpats_Radio_Db_If_Types.Output_Ident;
         Position : in Jrt.Position_Type;
         Heading  : in Jrt.Bearing_Type );

   procedure Capture_Holdshort(
         Airport  : in Jpats_Radio_Db_If_Types.Output_Ident;
         Runway   : in Jrt.String4;
         Position : in Jrt.Position_Type;
         Heading  : in Jrt.Bearing_Type );

   procedure Save_Ramps;

   procedure Save_Holdshorts;

private

   type Ramp_Type is
      record
         Airport  : Jpats_Radio_Db_If_Types.Output_Ident;
         Position : Jrt.Position_Type;
         Heading  : Jrt.Bearing_Type;
         Next     : Ramp_Access;
         Prev     : Ramp_Access;
      end record;

   Ramp_List : Ramp_Access := null;

   type Holdshort_Type is
      record
         Airport  : Jpats_Radio_Db_If_Types.Output_Ident;
         Runway   : Jrt.String4;
         Position : Jrt.Position_Type;
         Heading  : Jrt.Bearing_Type;
         Next     : Holdshort_Access;
         Prev     : Holdshort_Access;
      end record;

   Holdshort_List : Holdshort_Access := null;

end Reposition;
