-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package JPATS_Reposition_Types is

   Deg_To_Rad     : constant Float := 0.017453;

   subtype String4 is String(1 .. 4);

   subtype Ident_4_Type is String(1 .. 4);

   subtype Ident_3_Type is String(1 .. 3);

   subtype Ident_5_Type is String(1 .. 5);

   type Select_Type is array (1 ..5 ) of Ident_4_Type;

   subtype Bearing_Type is Float;

   subtype Heading_Type is Float range 0.0 .. 360.0;

   subtype Lat_Type is long_float range -90.0..90.0;

   subtype Lon_Type is long_float range -180.0..180.0;

   type Position_Type is
      record
         Latitude  : Lat_Type;
         Longitude : Lon_Type;
         Altitude  : Float;
      end record;

   type Reposition_Command_Type is
      record
         Active        : Boolean;
         Position      : Position_Type;
         Heading       : Bearing_Type;
         Airspeed      : Float;
         Flap_Position : Float;
         Gear_Position : Float;
         Torque        : Float;
         Parking_Brake : Boolean;
         On_Ground     : Boolean;
         Roll_Angle    : Float := 0.0;
         Pitch_Angle   : Float := 0.0;
      end record;

   type Windshear_Type is
      record
         Reference_Hdg : Heading_Type;
         Reference_Lat : Lat_Type;
         Reference_Lon : Lon_Type;
      end record;

   type Active_Runway_Type is
      record
         Airport_Ident     : String4;    --naptidnt
         Runway_Ident      : String4;    --nrwyidnt
         Airport_Elevation : Float;      --naptelv
         Airport_Latitude  : Long_Float; --naptlat
         Airport_Longitude : Long_Float; --naptlon
         Runway_Latitude   : Long_Float; --nrwylat
         Runway_Longitude  : Long_Float; --nrwylon
         Runway_Heading    : Float;      --nrwyhdg
         Runway_Length     : Float;      --nrwylen
         Runway_Width      : Float;      --nrwywid
      end record;

   --This is an attempt at defining the interface with the IOS.  It will
   --probably require modification as the requirements are further defined.
   type Reposition_Select_Type is
     (None,
      Ramp,
      Ils_8nm,
      Faf_5nm,
      Vfr_3nm,
      Flaps_Up_2nm,
      Flaps_To_2nm,
      Flaps_Ldg_2nm,
      Initial_2nm,
      Vfr_0p5nm,
      Takeoff,
      L_Localizer_Intercept,
      R_Localizer_Intercept,
      High_Key,
      R_Outside_Downwind,
      R_Downwind,
      R_Inside_Downwind,
      L_Outside_Downwind,
      L_Downwind,
      L_Inside_Downwind,
      Lat_Lon_Reposition,
      Ident_Reposition,
      Formation,
      Holdshort,
      Snapshot);

   for Reposition_Select_Type'Size use 32;

   type Reference_Valid_Type is
      record
         Airport_Valid : Boolean;
         Runway_Valid  : Boolean;
         Data_Valid    : Boolean;
      end record;

   type Formation_Delta_Type is
      record
         Fore_Aft    : Float;
         Left_Right  : Float;
         Above_Below : Float;
      end record;

end JPATS_Reposition_Types;