-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Jpats_Radio_Db_If_Types,
  JPATS_Reposition_Types;

package Jpats_Reposition is

   -- accessor functions, to make attributes available to
   -- other software subsystems

   function Reposition_Command return
     JPATS_Reposition_Types.Reposition_Command_Type;

   function Lat_Long_Reposition_Active return Boolean;

   procedure Set_Roll_Angle(Roll_Angle : in Float);

   procedure Set_Pitch_Angle(Pitch_Angle : in Float);

   function Windshear_Command return Jpats_Reposition_Types.Windshear_Type;

   function Reference_Airfield return Jpats_Radio_Db_If_Types.Apt_Struct_Type;

   function Reference_Runway return Jpats_Radio_Db_If_Types.Rwy_Struct_Type;

   function Selected_Airfield return Jpats_Radio_Db_If_Types.Apt_Struct_Type;

   function Selected_Runway return Jpats_Radio_Db_If_Types.Rwy_Struct_Type;

   function Active_Airfield return Jpats_Radio_Db_If_Types.Apt_Struct_Type;

   function Active_Runway return Jpats_Radio_Db_If_Types.Rwy_Struct_Type;

   function Formation_Delta return Jpats_Reposition_Types.Formation_Delta_Type;

   procedure Controls_Not_In_Agreement;

   procedure Abort_snapshot;

   procedure Takeoff;

end JPATS_Reposition;









