-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Reposition.Container;
with JPATS_Reposition_Types;
use JPATS_Reposition_Types;
package body JPATS_Reposition is

   function Reposition_Command
     return Jpats_Reposition_Types.Reposition_Command_Type is

   begin

      return Container.This_Subsystem.The_Reposition_Command;

   end Reposition_Command;

   function Lat_Long_Reposition_Active return Boolean is
   begin
     return (Container.This_Ios_Interface.Reposition_Select = JPATS_Reposition_Types.Lat_Lon_Reposition);
   end Lat_Long_Reposition_Active;

   procedure Set_Roll_Angle(Roll_Angle : in Float) is
   begin
      Container.This_Subsystem.The_Reposition_Command.Roll_Angle := Roll_Angle;
   end Set_Roll_Angle;

   procedure Set_Pitch_Angle(Pitch_Angle : in Float) is
   begin
      Container.This_Subsystem.The_Reposition_Command.Pitch_Angle := Pitch_Angle;
   end Set_Pitch_Angle;

   function Windshear_Command
     return Jpats_Reposition_Types.Windshear_Type is

   begin

      return Container.This_Subsystem.The_Windshear_Command;

   end Windshear_Command;

   function Reference_Airfield
     return Jpats_Radio_Db_If_Types.Apt_Struct_Type is

   begin

      return Container.This_Subsystem.The_Reference_Airfield;

   end;

   function Reference_Runway
     return Jpats_Radio_Db_If_Types.Rwy_Struct_Type is

   begin

      return Container.This_Subsystem.The_Reference_Runway;

   end;

   function Selected_Airfield
     return Jpats_Radio_Db_If_Types.Apt_Struct_Type is

   begin

      return Container.This_Subsystem.The_Selected_Airfield;

   end;

   function Selected_Runway
     return Jpats_Radio_Db_If_Types.Rwy_Struct_Type is

   begin

      return Container.This_Subsystem.The_Selected_Runway;

   end;

   function Active_Airfield
     return Jpats_Radio_Db_If_Types.Apt_Struct_Type is

   begin

      return Container.This_Subsystem.The_Active_Airfield;

   end;

   function Active_Runway
     return Jpats_Radio_Db_If_Types.Rwy_Struct_Type is

   begin

      return Container.This_Subsystem.The_Active_Runway;

   end;

   function Formation_Delta
     return Jpats_Reposition_Types.Formation_Delta_Type is

   begin

      return Container.This_Subsystem.The_Formation_Delta;

   end;

   procedure Controls_Not_In_Agreement is
   begin
      JPATS_Reposition.Container.This_Ios_Interface.Reposition_Select :=
        Jpats_Reposition_Types.Snapshot;
   end Controls_Not_In_Agreement;

   procedure Abort_Snapshot is
   begin
      JPATS_Reposition.Container.This_Ios_Interface.Reposition_Select :=
        Jpats_Reposition_Types.None;
   end Abort_Snapshot;

   procedure Takeoff is
   begin
      Container.This_Ios_Interface.Reposition_Select :=
        Jpats_Reposition_Types.Takeoff;
   end Takeoff;

end JPATS_Reposition;
