------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  First_Name Middle_Initial Last_Name
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Reposition.Container,
  JPATS_IOS_Interface;
with Ada.Characters.Handling;

use Ada.Characters.Handling;

package body JPATS_Reposition.Ios_If is

   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;

   Temp_Int : Integer;

   procedure Set_Airport_Change( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Airport_Change := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Airport_Change;

   procedure Set_Environment_Change( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Environment_Change := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Environment_Change;

   procedure Set_Ramp_Changes( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Ramp_Changes := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Ramp_Changes;

   procedure Set_Holdshort_Changes( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Holdshort_Changes := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Holdshort_Changes;

   procedure Set_Capture_Ramp( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Capture_Ramp := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Capture_Ramp;

   procedure Set_Capture_Holdshort( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Capture_Holdshort := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Capture_Holdshort;

   procedure Set_Save_Ramps( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Save_Ramps := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Save_Ramps;

   procedure Set_Save_Holdshorts( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Save_Holdshorts := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Save_Holdshorts;

   procedure Set_Refresh_Ramps( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Refresh_Ramps := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Refresh_Ramps;

   procedure Set_Refresh_Holdshorts( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Refresh_Holdshorts := JPATS_IOS_Interface.Convert_To_Bool( pData );
   end Set_Refresh_Holdshorts;

   procedure Set_Airport( pData     : JPATS_IOS_Interface.Set_Value;
                          Offset1d  : Integer;
                          Offset2d  : Integer;
                          Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Airport(Offset1d+1):=' ';
      else
         Ios.Airport(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Airport(Offset1d+1) := To_Upper(Ios.Airport(Offset1d+1));
      Ios.Airport_Was_Set := Completed;
   end Set_Airport;

   procedure Set_Runway( pData     : JPATS_IOS_Interface.Set_Value;
                         Offset1d  : Integer;
                         Offset2d  : Integer;
                         Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Runway(Offset1d+1):=' ';
      else
         Ios.Runway(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Runway(Offset1d+1) := To_Upper(Ios.Runway(Offset1d+1));
      Ios.Runway_Was_Set := Completed;
   end;

   procedure Set_Altitude( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Altitude := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Altitude_Was_Set := True;
   end Set_Altitude;

   procedure Set_Airspeed( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Airspeed := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Airspeed_Was_Set := True;
   end Set_Airspeed;

   procedure Set_Heading( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Heading := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Heading_Was_Set := True;
   end Set_Heading;

   procedure Set_Latitude( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Latitude := JPATS_IOS_Interface.Convert_To_Long_Float( pData );
      Ios.Latitude_Was_Set := True;
   end Set_Latitude;

   procedure Set_Longitude( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Longitude := JPATS_IOS_Interface.Convert_To_Long_Float( pData );
      Ios.Longitude_Was_Set := True;
   end Set_Longitude;

   procedure Set_Ident( pData     : JPATS_IOS_Interface.Set_Value;
                        Offset1d  : Integer;
                        Offset2d  : Integer;
                        Completed : Boolean) is
   begin
      if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
         Ios.Ident(Offset1d+1):=' ';
      else
         Ios.Ident(Offset1d+1) :=
           JPATS_IOS_Interface.Convert_To_Character( pData );
      end if;
      Ios.Ident(Offset1d+1) := To_Upper(Ios.Ident(Offset1d+1));
      Ios.Ident_Was_Set := Completed;
   end;

   procedure Set_Radial( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Radial := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Radial_Was_Set := True;
   end Set_Radial;

   procedure Set_Distance( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Distance := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Distance_Was_Set := True;
   end Set_Distance;

   procedure Set_Fore_Aft( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Fore_Aft := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Fore_Aft_Was_Set := True;
   end Set_Fore_Aft;

   procedure Set_Above_Below( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Above_Below := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Above_Below_Was_Set := True;
   end Set_Above_Below;

   procedure Set_Left_Right( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Left_Right := JPATS_IOS_Interface.Convert_To_Float( pData );
      Ios.Left_Right_Was_Set := True;
   end Set_Left_Right;

   procedure Set_Reposition_Select( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Temp_Int := JPATS_IOS_Interface.Convert_To_Integer( pData );
      Ios.Reposition_Select := Jrt.Reposition_Select_Type'Val(Temp_Int);
      Ios.Reposition_Select_Was_Set := True;
   end Set_Reposition_Select;

   procedure Set_Reposition_Formation_Id( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Reposition_Formation_Id :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
   end Set_Reposition_Formation_Id;

   procedure Register_Ios_Variables  is

   begin

      JPATS_IOS_Interface.Register
        (Name        => "Cnia_Display_Page",
         Variable    => Container.This_Ios_Interface.Cnia_Display_Page'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cnia_Required_Gear",
         Variable    => Container.This_Ios_Interface.Cnia_Required_Gear'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cnia_Required_Flaps",
         Variable    => Container.This_Ios_Interface.Cnia_Required_Flaps'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cnia_Required_Torque",
         Variable    => Container.This_Ios_Interface.Cnia_Required_Torque'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Cnia_Required_Parking_Brake",
         Variable    => Container.This_Ios_Interface.Cnia_Required_Parking_Brake'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Airport_Change",
         Variable    => Container.This_Ios_Interface.Airport_Change'address,
         Set_Routine => Set_Airport_Change'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Environment_Change",
         Variable    => Container.This_Ios_Interface.Environment_Change'address,
         Set_Routine => Set_Environment_Change'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ramp_Changes",
         Variable    => Container.This_Ios_Interface.Ramp_Changes'address,
         Set_Routine => Set_Ramp_Changes'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Holdshort_Changes",
         Variable    => Container.This_Ios_Interface.Holdshort_Changes'address,
         Set_Routine => Set_Holdshort_Changes'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Capture_Ramp",
         Variable    => Container.This_Ios_Interface.Capture_Ramp'address,
         Set_Routine => Set_Capture_Ramp'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Capture_Holdshort",
         Variable    => Container.This_Ios_Interface.Capture_Holdshort'address,
         Set_Routine => Set_Capture_Holdshort'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Save_Ramps",
         Variable    => Container.This_Ios_Interface.Save_Ramps'address,
         Set_Routine => Set_Save_Ramps'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Save_Holdshorts",
         Variable    => Container.This_Ios_Interface.Save_Holdshorts'address,
         Set_Routine => Set_Save_Holdshorts'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Refresh_Ramps",
         Variable    => Container.This_Ios_Interface.Refresh_Ramps'address,
         Set_Routine => Set_Refresh_Ramps'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Refresh_Holdshorts",
         Variable    => Container.This_Ios_Interface.Refresh_Holdshorts'address,
         Set_Routine => Set_Refresh_Holdshorts'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Altitude",
         Variable    => Container.This_Ios_Interface.Altitude'address,
         Set_Routine => Set_Altitude'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Airspeed",
         Variable    => Container.This_Ios_Interface.Airspeed'address,
         Set_Routine => Set_Airspeed'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Heading",
         Variable    => Container.This_Ios_Interface.Heading'address,
         Set_Routine => Set_Heading'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Latitude",
         Variable    => Container.This_Ios_Interface.Latitude'address,
         Set_Routine => Set_Latitude'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Longitude",
         Variable    => Container.This_Ios_Interface.Longitude'address,
         Set_Routine => Set_Longitude'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Radial",
         Variable    => Container.This_Ios_Interface.Radial'address,
         Set_Routine => Set_Radial'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Distance",
         Variable    => Container.This_Ios_Interface.Distance'address,
         Set_Routine => Set_Distance'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fore_Aft",
         Variable    => Container.This_Ios_Interface.Fore_Aft'address,
         Set_Routine => Set_Fore_Aft'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Above_Below",
         Variable    => Container.This_Ios_Interface.Above_Below'address,
         Set_Routine => Set_Above_Below'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Left_Right",
         Variable    => Container.This_Ios_Interface.Left_Right'address,
         Set_Routine => Set_Left_Right'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Select",
         Variable    => Container.This_Ios_Interface.Reposition_Select'address,
         Set_Routine => Set_Reposition_Select'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Reposition_Formation_Id",
         Variable    => Container.This_Ios_Interface.Reposition_Formation_Id'address,
         Set_Routine => Set_Reposition_Formation_Id'access
         );

   end Register_Ios_Variables;

end JPATS_Reposition.IOS_If;

