-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Reposition;

package JPATS_Reposition.Container is

   package Jrt renames Jpats_Reposition_Types;

   type Instance is
      record
         The_Reference_Airfield : Jpats_Radio_Db_If_Types.Apt_Struct_Type;
         The_Reference_Runway : Jpats_Radio_Db_If_Types.Rwy_Struct_Type;
         The_Selected_Airfield : Jpats_Radio_Db_If_Types.Apt_Struct_Type;
         The_Selected_Runway : Jpats_Radio_Db_If_Types.Rwy_Struct_Type;
         The_Active_Airfield : Jpats_Radio_Db_If_Types.Apt_Struct_Type;
         The_Active_Runway : Jpats_Radio_Db_If_Types.Rwy_Struct_Type;
         The_Reposition_Command :
           Jpats_Reposition_Types.Reposition_Command_Type;
         The_Windshear_Command  : Jpats_Reposition_Types.Windshear_Type;
         The_Formation_Delta : Jpats_Reposition_Types.Formation_Delta_Type;
      end record;

   This_Subsystem : Instance;

   Io_Size : Constant := 4;

   type Io_Interface_Instance is
      record
         --Ios Panel
         Approach_Iaf_Amber : Boolean := False;
         Approach_Iaf_Green : Boolean := True;
         Approach_Iaf_On    : Boolean;
         Approach_Iaf_Off   : Boolean;
         To_Point_Amber     : Boolean := False;
         To_Point_Green     : Boolean := True;
         To_Point_On        : Boolean;
         To_Point_Off       : Boolean;
      end record;

   for Io_Interface_Instance use
      record
         Approach_Iaf_Amber at 000*Io_Size range 0 .. 31;
         Approach_Iaf_Green at 001*Io_Size range 0 .. 31;
         Approach_Iaf_On    at 002*Io_Size range 0 .. 31;
         Approach_Iaf_Off   at 003*Io_Size range 0 .. 31;
         To_Point_Amber     at 004*Io_Size range 0 .. 31;
         To_Point_Green     at 005*Io_Size range 0 .. 31;
         To_Point_On        at 006*Io_Size range 0 .. 31;
         To_Point_Off       at 007*Io_Size range 0 .. 31;
      end record;

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Airport_Change            : Boolean := True;
         Environment_Change        : Boolean := False;
         Ramp_Changes              : Boolean := False;
         Holdshort_Changes         : Boolean := False;
         Capture_Ramp              : Boolean := False;
         Capture_Holdshort         : Boolean := False;
         Save_Ramps                : Boolean := False;
         Save_Holdshorts           : Boolean := False;
         Refresh_Ramps             : Boolean := False;
         Refresh_Holdshorts        : Boolean := False;
         Airport                   : Jrt.Ident_4_Type := "KDLF";
         Runway                    : Jrt.Ident_4_Type := "13C ";
         Active_Airport            : Jrt.Ident_4_Type := "KDLF";
         Active_Runway             : Jrt.Ident_4_Type := "13C ";
         Altitude                  : Float := 0.0;
         Airspeed                  : Float := 0.0;
         Heading                   : Float := 0.0;
         Latitude                  : Jrt.Lat_Type := 0.0;
         Longitude                 : Jrt.Lon_Type := 0.0;
         Ident                     : Jrt.Ident_4_Type := "    ";
         Radial                    : Float := 0.0;
         Distance                  : Float := 0.0;
         Fore_Aft                  : Float := 0.0;
         Left_Right                : Float := 0.0;
         Above_Below               : Float := 0.0;
         Reposition_Select         : Jrt.Reposition_Select_Type;
         Reposition_Formation_Id   : Integer := 0;

         Airport_Was_Set           : Boolean := False;
         Runway_Was_Set            : Boolean := False;
         Altitude_Was_Set          : Boolean := False;
         Airspeed_Was_Set          : Boolean := False;
         Heading_Was_Set           : Boolean := False;
         Latitude_Was_Set          : Boolean := False;
         Longitude_Was_Set         : Boolean := False;
         Ident_Was_Set             : Boolean := False;
         Radial_Was_Set            : Boolean := False;
         Distance_Was_Set          : Boolean := False;
         Fore_Aft_Was_Set          : Boolean := False;
         Left_Right_Was_Set        : Boolean := False;
         Above_Below_Was_Set       : Boolean := False;
         Reposition_Select_Was_Set : Boolean := False;

         Cnia_Display_Page         : Boolean := False;
         Cnia_Required_Gear        : Boolean := False;
         Cnia_Required_Flaps       : Integer := 0;
         Cnia_Required_Torque      : Float   := 0.0;
         Cnia_Required_Parking_Brake : Boolean := False;
      end record;

   This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Reposition.Container;
