-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Real_Time;
with Ada.Streams;

-------------------------------------------------------------------------------
-- This package defines a header class for data saved on a buffer stream
-------------------------------------------------------------------------------
package Saved_Data_Header is

   type Instance is private;


   -------------------------------------------------------------------------------
   -- Returns the number of bytes in an instance of a saved data header.
   -- This number does not change, and may be treated as a constant.
   -------------------------------------------------------------------------------
   function Bytes return Natural;

   -------------------------------------------------------------------------------
   -- Returns the number of stream elements in an instance of a saved data header.
   -- This number does not change, and may be treated as a constant.
   -------------------------------------------------------------------------------
   function Elements return Ada.Streams.Stream_Element_Offset;

   -------------------------------------------------------------------------------
   -- Simple routines to convert to and from a Data_Header.
   -------------------------------------------------------------------------------
   function To_Stream_Element_Array (Source : in Instance) return
     Ada.Streams.Stream_Element_Array;
   function From_Stream_Element_Array (Source : in Ada.Streams.Stream_Element_Array) return
     Instance;

   -------------------------------------------------------------------------------
   -- Accessor methods to get the size from a header
   -------------------------------------------------------------------------------
   function Size (Header : in Instance) return Natural;
   function Size (Header : in Ada.Streams.Stream_Element_Array) return Natural;

   -------------------------------------------------------------------------------
   -- Accessor methods to get the time from a header
   -------------------------------------------------------------------------------
   function Time (Header : in Instance) return Ada.Real_Time.Time;
   function Time (Header : in Ada.Streams.Stream_Element_Array) return Ada.Real_Time.Time;

   -------------------------------------------------------------------------------
   -- Constructor methods
   -------------------------------------------------------------------------------
   function Create (Size : in Natural;
                    Time : in Ada.Real_Time.Time
                   ) return Instance;
   function Create (Size : in Natural;
                    Time : in Ada.Real_Time.Time
                   ) return Ada.Streams.Stream_Element_Array;

private

   -------------------------------------------------------------------------------
   -- Write method.
   -- This method is guaranteed to have the same effect as calling
   -- Write (Stream, To_Stream_Element_Array(Item)) on the given stream.
   -------------------------------------------------------------------------------
   procedure Write
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : in     Instance
     );

   -------------------------------------------------------------------------------
   -- Read method.
   -- This method is guaranteed to have the same effect as calling
   -- Read (Stream, To_Stream_Element_Array(Item), Trash) on the given stream
   -- (except that the To_Stream_Element_Array part isn't quite legal).
   -------------------------------------------------------------------------------
   procedure Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : out    Instance
     );

   type Instance is record
      Size : Natural;
      Time : Ada.Real_Time.Time;
   end record;
   for Instance'Write use Write;
   for Instance'Read use Read;

end Saved_Data_Header;
