-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Strings.Bounded;

-------------------------------------------------------------------------------
-- This package provides the IOS interface for the Save/Restore facility.
-------------------------------------------------------------------------------
package Save_Restore.IOS_Interface is

   package Bounded_64 is new Ada.Strings.Bounded.Generic_Bounded_Length(64);
   subtype Demo_Profile_Name_Type is Bounded_64.Bounded_String;

   Filename_Length                     : constant Natural := 64;
   Spaces                              : constant Demo_Profile_Name_Type := 
                                          Bounded_64.Head(
                                          Bounded_64.To_Bounded_String(" "),
                                          Bounded_64.Max_Length);
   Formation_Demo_Profile_Name         : String(1..Filename_Length) := Bounded_64.to_string(Spaces);
   Allow_Demo_Select                   : Boolean := True;
   Allow_Offset_Adjustment             : Boolean := False;
   Play_Formation_Demo                 : Boolean := False;
   Record_Formation_Demo               : Boolean := False;
   New_Formation_Demo_Loaded           : Boolean := False;
   Formation_Demo_Leadship_Loaded      : Boolean := False;
   Formation_Demo_Leadship_Only        : Boolean := False;
   Formation_Demo_Track_Number         : Integer := 1;
   Auto_Fly_Out                        : Boolean := False;

   -------------------------------------------------------------------------------
   -- This routine changes the replay delta that the IOS displays to the operator.
   -------------------------------------------------------------------------------
   procedure Update_Replay_Delta (New_Delta : in Duration);

   -------------------------------------------------------------------------------
   -- Register this package's IOS variables.
   -- This must be called after the JPATS_IOS_Interface package has been
   -- initialized, but before the JPATS_Hostcomms_Scheduler has been initialized.
   -------------------------------------------------------------------------------
   procedure Register_Variables;

   ----------------------------------------------------------------------------
   -- This routine notifies the IOS that the a replay has been trimmed.
   ----------------------------------------------------------------------------
   procedure Replay_Ready;

   ----------------------------------------------------------------------------
   -- This routine notifies the IOS that the a replay has completed.
   ----------------------------------------------------------------------------
   procedure Replay_Complete;

   ----------------------------------------------------------------------------
   -- This routine notifies the IOS that the demo file has been saved.
   ----------------------------------------------------------------------------
   procedure Demo_File_Saved;

   ----------------------------------------------------------------------------
   -- This routine modifies the demo file length. This should be called after
   -- a demo replay is started before any call to Update_Replay_Delta.
   ----------------------------------------------------------------------------
   procedure Set_Demo_File_Length (Seconds : in Duration);

   procedure Init_Formation_Demo_Replay_Delta;

end Save_Restore.IOS_Interface;

