-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Buffer_Stream.Save;
with Log;
with Save_Restore;

with Ada.Exceptions;
with Ada.Characters.Latin_1;

-------------------------------------------------------------------------------
-- This package provides an active object that notifies the save/restore server
-- whenever the given scheduler gets new data on its save stream.
-------------------------------------------------------------------------------
package body Restore_Stream_Notifier is

   task body Agent is
      Source   : Buffer_Stream.Restore.Handle;
      Required : Natural;

   begin
      loop

         -- Get an job.
         accept Look_For
           (Stream : in Buffer_Stream.Restore.Handle;
            Amount : in Natural
           )
         do
            Source   := Stream;
            Required := Amount;
         end Look_For;

         -- Wait for new data to arrive on the save stream
         Buffer_Stream.Restore.Wait_For_Space
           (Stream => Source,
            Amount => Required
            );

         -- Notify the save_restore server
         Save_Restore.Restore_Space_Arrived;
      end loop;

   exception
      when Error : others =>
         Log.Report (Event => "Restore_Stream_Notifier.Agent terminated due to " &
                     "unhandled exception." & Ada.Characters.Latin_1.Cr &
                     Ada.Characters.Latin_1.Lf &
                     Ada.Exceptions.Exception_Information (Error),
                     Severity => Log.Error);

   end Agent;


end Restore_Stream_Notifier;
