-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Subsystem_Scheduler;

-------------------------------------------------------------------------------
-- This package provides control over the record/playback functionality.
-------------------------------------------------------------------------------
package Record_Playback is

   ----------------------------------------------------------------------------
   -- Check to see if its time to snapshot all the models yet.
   -- The time is based on the time of previous calls to this routine.
   ----------------------------------------------------------------------------
   function Model_Snapshot_Time return Boolean;

   -------------------------------------------------------------------------------
   -- Enable or disable saving of model data. An input value of False indicates
   -- saving is to be disabled. Saving is enabled by default.
   -------------------------------------------------------------------------------
   procedure Enable_Saving ( Enable : in Boolean := True);

   -------------------------------------------------------------------------------
   -- Take a snapshot of the state of the given module
   -------------------------------------------------------------------------------
   procedure Snapshot (Module : in out Subsystem_Scheduler.Instance'Class);

   -------------------------------------------------------------------------------
   -- Attempt to restore the state of the given module, if need be.
   -------------------------------------------------------------------------------
   procedure Restore (Module : in out Subsystem_Scheduler.Instance'Class);

end Record_Playback;
