-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Streams;
with Buffer_Stream;  -- Parent Class

-------------------------------------------------------------------------------
-- This package provides a child class of buffer_stream to allow saving of
-- data in a task-safe and structured manner.
--
-- A buffer stream is created with a certian max size of data it may hold. When
-- a write is attempted and there isn't enough room, old *series* of writes
-- (delimited by Open_Writes and Close_Writes pairs) will be deleted to make
-- room if possible. If this occurs, the deletion will start with the oldest
-- series of writes and move forward.
-------------------------------------------------------------------------------
package Buffer_Stream.Save is

   type Instance is new Buffer_Stream.Instance with private;

   type Handle is access all Instance'Class;


   --
   -- Overrides of inherited routines
   --

   -------------------------------------------------------------------------------
   -- Return True if data is available in the stream.
   -------------------------------------------------------------------------------
   function Data_available (Stream : access Instance) return Boolean;

   -------------------------------------------------------------------------------
   -- Return the amount of data available in the stream.
   -------------------------------------------------------------------------------
   function Data_available (Stream : access Instance) return Natural;

   -------------------------------------------------------------------------------
   -- Prepare for a series of writes to the stream. This routine should be called
   -- before a stream is written to.
   -- This implementation attempts to lock the stream. If it can't get the lock
   -- immdediately, it returns with success of FALSE. Otherwise it puts a size
   -- header in the stream and locks it.
   -------------------------------------------------------------------------------
   procedure Open_Writes (Stream  : in out Instance;
                          Success :    out Boolean);

   -------------------------------------------------------------------------------
   -- Complete a series of writes to the stream. This routine will be called
   -- after a series of writes has completed.
   -- This implementation fills in the size header, places a perforation marker,
   -- and unlocks the stream.
   -------------------------------------------------------------------------------
   procedure Close_Writes (Stream : in out Instance);

private
   type Instance is new Buffer_Stream.Instance with record
      Header_Location : Buffer_Stream.Stream_Buffer.Write_Location;
      Amount_Written  : Natural := 0;
   end record;

   -------------------------------------------------------------------------------
   -- Reimplementation of the inherited Write routine from Root_Stream_Type.
   -------------------------------------------------------------------------------
   procedure Write
     (Stream : in out Instance;
      Item   : in     Ada.Streams.Stream_Element_Array
     );

end Buffer_Stream.Save;
