-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Interfaces.C;

package JPATS_Radio_Db_IF_Types is

   type Rdb_Init_Type is new Interfaces.C.Long;

   subtype Lat_Type is Long_Float range -90.0 .. 90.0;

   subtype Lon_Type is Long_Float range -180.0 .. 180.0;

   type Position_Type is
      record
         Latitude  : Lat_Type := 0.0;
         Longitude : Lon_Type := 0.0;
         Altitude  : Float    := 0.0;
      end record;

   subtype Input_Ident is String (1..5);

   subtype Output_Ident is String (1 .. 4);

   type Bitfield is array (0 .. 31) of Boolean;
   pragma Pack(Bitfield);
   for Bitfield'Size use 32;

   type Receiver_Type is (Off,Align,Vor_Ils,Mls,Dme,Tacan,Adf,Com,Mkr);
   for Receiver_Type'Size use 32;

   type RCVR_REQUEST_TYPE is
      record
         Ac_Lat    : Lat_Type := 0.0; --Aircraft latitude, decimal degrees
         Ac_Lon    : Lon_Type := 0.0; --Aircraft longitude, decimal degrees
         Freq      : Integer  := 0;   --Receiver Frequency
                                      --VOR, ILS, DME, TACAN, COM  => Mhz x 100
                                      --MLS => Channel x10
                                      --ADF => Khz x 10
         Rcvr      : Receiver_Type := Off;   --Receiver Type
                                      --0=OFF,1=Align, 2=VOR/ILS, 3=MLS, 4=DME,
                                      --5=TACAN,6=ADF, 7=COM, 8=MKR, 9=Reserved
                                      --10=Reserved
         Bandwidth : Integer := 0;    --ADF Bandwidth for Analog tuning
         --Airport Ident(for ILS priority select)
         Apt_Idnt  : Input_Ident := "     ";
         --Runway  Ident(for ILS priority select)
         Rwy_Idnt  : Input_Ident := "     ";
      end record;

   for RCVR_REQUEST_Type use
      record
         Ac_Lat    at   0 range 0 .. 63;
         Ac_Lon    at   8 range 0 .. 63;
         Freq      at  16 range 0 .. 31;
         Rcvr      at  20 range 0 .. 31;
         Bandwidth at  24 range 0 .. 31;
         Apt_Idnt  at  28 range 0 .. 39;
         Rwy_Idnt  at  33 range 0 .. 39;
      end record;


   type STN_STRUCT_TYPE is
      record
         Idnt : Output_Ident := "    ";      --NSTNIDNT  I*4 ASCII
         Icao : Output_Ident := "    ";      --NSTNICAO  I*4 ASCII
         Typ1 : Bitfield; --NSTNTYP   I*4 Bits
         Typ2 : Bitfield; --NSTN2TYP  I*4 Bits
         Rng  : Float := 0.0;                --NSTNRNG   R*4 Nm.
         Lat  : Lat_Type := 0.0;             --NSTNLAT   R*8 Degr.
         Lon  : Lon_Type := 0.0;             --NSTNLON   R*8 Degr.
         Var  : Float := 0.0;                --NSTNVAR   R*4 Deg
         Elv  : Float := 0.0;                --NSTNELV   R*4 Feet MSL
         Frq  : Integer := 0;                --NSTNFRQ   I*4 Mhz x 100
                                             --              Khz x 10
                                             --              Channel x10
         Hdg  : Float := 0.0;                --NSTNHDG   R*4 Degr.
         Aid  : Output_Ident := "    ";      --NSTNAID   I*4 ASCII
         Rid  : Output_Ident := "    ";      --NSTNRID   I*4 ASCII
         Lgd  : Float := 0.0;                --NSTNLGD   I*4 Feet
         Lbw  : Float := 0.0;                --NSTNLBW   R*4 Degr.
         Gsa  : Float := 0.0;                --NSTNGSA   R*4 Degr.
         Gsw  : Float := 0.0;                --NSTNGSW   R*4 Degr.
         Gtd  : Integer := 0;                --NSTNGTD   I*4 Feet.
         Bad  : Float := 0.0;                --NSTNBAD   R*4 Ft.
         Apal : Float := 0.0;                --NSTNAPAL  R*4 Degr.
         Apar : Float := 0.0;                --NSTNAPAR  R*4 Degr.
         Acal : Float := 0.0;                --NSTNACAL  R*4 Degr.
         Acar : Float := 0.0;                --NSTNACAR  R*4 Degr
         Mgpa : Float := 0.0;                --NSTNMGPA  R*4 Degr.
         Bpal : Float := 0.0;                --NSTNBPAL  R*4 Degr.
         Bpar : Float := 0.0;                --NSTNBPAR  R*4 Degr.
         Bpcl : Float := 0.0;                --NSTNBPCL  R*4 Degr.
         Bpcr : Float := 0.0;                --NSTNBPCR  R*4 Degr.
         Bhdg : Float := 0.0;                --NSTNBHDG  R*4 Degr.
      end record;

   for STN_STRUCT_TYPE use
      record
         Idnt at   0 range 0 .. 31;
         Icao at   4 range 0 .. 31;
         Typ1 at   8 range 0 .. 31;
         Typ2 at  12 range 0 .. 31;
         Rng  at  16 range 0 .. 31;
         Lat  at  20 range 0 .. 63;
         Lon  at  28 range 0 .. 63;
         Var  at  36 range 0 .. 31;
         Elv  at  40 range 0 .. 31;
         Frq  at  44 range 0 .. 31;
         Hdg  at  48 range 0 .. 31;
         Aid  at  52 range 0 .. 31;
         Rid  at  56 range 0 .. 31;
         Lgd  at  60 range 0 .. 31;
         Lbw  at  64 range 0 .. 31;
         Gsa  at  68 range 0 .. 31;
         Gsw  at  72 range 0 .. 31;
         Gtd  at  76 range 0 .. 31;
         Bad  at  80 range 0 .. 31;
         Apal at  84 range 0 .. 31;
         Apar at  88 range 0 .. 31;
         Acal at  92 range 0 .. 31;
         Acar at  96 range 0 .. 31;
         Mgpa at 100 range 0 .. 31;
         Bpal at 104 range 0 .. 31;
         Bpar at 108 range 0 .. 31;
         Bpcl at 112 range 0 .. 31;
         Bpcr at 116 range 0 .. 31;
         Bhdg at 120 range 0 .. 31;
     end record;

   type Marker_Type is (Outer,Middle,Inner);
   type Mrkr_Stn_Struct is array (Marker_Type) of Stn_Struct_Type;
   type Marker_Float is array (Marker_Type) of Float;

   subtype Stn_Idnt_Type is String (1 .. 4);

   type Kill_Mode_Type is (Nul,Kill,Reset,Reset_All);
   for Kill_Mode_Type'Size use 32;

   type Mask_Type is mod 2**32;
   type Mask_Array_Type is array (1 .. 16) of Mask_Type;

   type Stn_Kill_Request_Type is
      record
         --Kill Ident/ASCII Option
         Stn_Idnt  : Stn_Idnt_Type := "    ";
         Kill_Optn : Mask_Type := 0;         --Bitwise mask for partial kill
         Kill_Mode : Kill_Mode_Type := Kill; --Kill Mode: Default to Kill
                                             --0= NULL,1=Kill,2=Reset,3=Reset All
         Mkr_Kill  : Integer := 1;           --Marker Kill Option w/ ILS Kills
      end record;

   for Stn_Kill_Request_Type use
      record
         Stn_Idnt  at   0 range 0 .. 31;
         Kill_Optn at   4 range 0 .. 31;
         Kill_Mode at   8 range 0 .. 31;
         Mkr_Kill  at  12 range 0 .. 31;
      end record;
   for Stn_Kill_Request_Type'Size use 128;

   type Pstn_Kill_Request_Type is access all Stn_Kill_Request_Type;

   type Aptrwy_Request_Type is
      record
         Apt_Idnt      : Input_Ident := "     "; --Airport Identifier
         Rwy_Idnt      : Input_Ident := "     "; --Runway  Identifier
         Rwy_Sort_Mode : Integer := 0;--0 = Alpha list starting with
                                      -- element 0 w/o duplicates in 1..n
                                      --1 = Longest (and lowest #) runway
                                      --in element 0 w/ duplicates in 1..n
                                      --2 = Selected runway in element 0
                                      --w/ duplicates in 1..N
                                      --3 = Selected runway in element 0
                                      --w/o duplicates in 1..n
      end record;

   for Aptrwy_Request_Type use
      record
         Apt_Idnt      at   0 range 0 .. 39;
         Rwy_Idnt      at   5 range 0 .. 39;
         Rwy_Sort_Mode at  10 range 0 .. 31;
      end record;

   subtype Name_Type is String (1 .. 32);

   type Rwy_Type is array (1 .. 20, 1 .. 4) of Character;

   subtype Bearing_Type is Float range -180.0 .. 180.0;

   type Apt_Struct_Type is
      Record
         Idnt : Output_Ident; --NAPTIDNT  I*4 ASCII
         Icao : Output_Ident; --NAPTICAO  I*4 ASCII
         Ata  : Output_Ident; --NAPT2IDT  I*4 ASCII
         Typ1 : Bitfield;     --NAPTTYP   I*4 Bits
         Typ2 : Bitfield;     --NAPT2TYP  I*4 Bits
         Lat  : Lat_Type;     --NAPTLAT   R*8 Degr.
         Lon  : Lon_Type;     --NAPTLON   R*8 Degr.
         Var  : Bearing_Type; --NAPTVAR   R*4 Degr.
         Elv  : Float;        --NAPTELV   R*4 Feet
         Name : Name_Type;    --NAPTNAME  I*4(8)ASCII
         Rwy  : Rwy_Type;     --NAPTRWY   I*4(20)ASCII
      end record;

   for Apt_Struct_Type use
      record
         Idnt at   0 range 0 .. 31;
         Icao at   4 range 0 .. 31;
         Ata  at   8 range 0 .. 31;
         Typ1 at  12 range 0 .. 31;
         Typ2 at  16 range 0 .. 31;
         Lat  at  20 range 0 .. 63;
         Lon  at  28 range 0 .. 63;
         Var  at  36 range 0 .. 31;
         Elv  at  40 range 0 .. 31;
         Name at  44 range 0 .. 255;
         Rwy  at  76 range 0 .. 639;
      end record;

   subtype Heading_Type is Float range 0.0 .. 360.0;

   type Afrq_Base_Type is array(1 ..3) of integer;
   subtype Afrq_Type is Afrq_Base_Type;

   type Int_16 is new Integer range -2**15 .. 2**15 - 1;
   for Int_16'Size use 16;

   type Rwy_Struct_Type is
      record
         Idnt     : Output_Ident;  --NRWYIDNT  I*4 ASCII
         Icao     : Output_Ident;  --NRWYICAO  I*4 ASCII
         Typ1     : Bitfield;      --NRWYTYP   I*4 Bits
         Typ2     : Integer;       --NRWY2TYP  I*2 Bits
         Hdg      : Heading_Type;  --NRWYHDG   R*4 Degr.
         Lat      : Lat_Type;      --NRWYLAT   R*8 Degr.
         Lon      : Lon_Type;      --NRWYLON   R*8 Degr.
         Len      : Float;         --NRWYLEN   R*4 Feet
         Dtr      : Float;         --NRWYDTR   R*4 Feet
         Wid      : Float;         --NRWYWID   R*4 Feet
         Lid      : Output_Ident;  --NRWYLID   I*4 ASCII
         Aid      : Output_Ident;  --NRWYAID   I*4 ASCII
         Ifrq     : Integer;       --NRWYIFRQ  i*4 Mhz*100
         Afrq     : Afrq_type;     --NRWYU1FQ  I*4 Mhz*100
      end record;

   for Rwy_Struct_Type use
      record
         Idnt at    0 range 0 .. 31;
         Icao at    4 range 0 .. 31;
         Typ1 at    8 range 0 .. 31;
         Typ2 at   12 range 0 .. 31;
         Hdg  at   16 range 0 .. 31;
         Lat  at   20 range 0 .. 63;
         Lon  at   28 range 0 .. 63;
         Len  at   36 range 0 .. 31;
         Dtr  at   40 range 0 .. 31;
         Wid  at   44 range 0 .. 31;
         Lid  at   48 range 0 .. 31;
         Aid  at   52 range 0 .. 31;
         Ifrq at   56 range 0 .. 31;
         Afrq at   60 range 0 .. 95;
      end record;


   type Ip_Request_Type is
      record
         Lat      : Lat_Type;    --Aircraft/General IP latitude
         Lon      : Lon_Type;    --Aircraft/General IP longitude
         Ip_Idnt  : Input_Ident; --IP Identifier (4chars, NULL terminated)
         Ip_Optn  : Input_Ident; --IP Options (4chars, NULL terminated)
         Apt_Idnt : Input_Ident; --Airport identifer for T/O types of IP's
      end record;

   for Ip_Request_Type use
      record
         Lat      at    0 range 0 .. 63;
         Lon      at    8 range 0 .. 63;
         Ip_Idnt  at   16 range 0 .. 39;
         Ip_Optn  at   21 range 0 .. 39;
         Apt_Idnt at   26 range 0 .. 39;
      end record;

   type Ip_Struct_Type is
      record
         Idnt : Output_Ident; --NSIPIDNT  I*4 ASCII
         Optn : Output_Ident; --NSIPOPTN  I*4 ASCII
         Slat : Lat_Type;     --NSIPSLAT  R*8 Deg.
         Slon : Lon_Type;     --NSIPSLON  R*8 Deg.
         Mlat : Lat_Type;     --NSIPMLAT  R*8 Degr.
         Mlon : Lon_Type;     --NSIPMLON  R*8 Degr.
         Typ1 : Bitfield;     --NSIPTYP1  I*4
         Typ2 : Bitfield;     --NSIPTYP2  I*4
         Var  : Bearing_Type; --NSIPVAR   R*4 deg
         Elv  : Float;        --NSIPELV   R*4 feet
         Hdg  : Heading_Type; --NSIPHDG   R*4 Deg.
         Lgd  : Float;        --NSIPLGD   R*4 Feet
         Gsa  : Float;        --NSIPGSA   R*4 Degr.
      end record;

   for Ip_Struct_Type use
      record
         Idnt at    0 range 0 .. 31;
         Optn at    4 range 0 .. 31;
         Slat at    8 range 0 .. 63;
         Slon at   16 range 0 .. 63;
         Mlat at   24 range 0 .. 63;
         Mlon at   32 range 0 .. 63;
         Typ1 at   40 range 0 .. 31;
         Typ2 at   44 range 0 .. 31;
         Var  at   48 range 0 .. 31;
         Elv  at   52 range 0 .. 31;
         Hdg  at   56 range 0 .. 31;
         Lgd  at   60 range 0 .. 31;
         Gsa  at   64 range 0 .. 31;
      end record;

   type Ac_Struct_Type is
      record
         Lat   : Lat_Type;     --Aircraft latitude, decimal degrees
         Lon   : Lon_Type;     --Aircraft longitude, decimal degrees
         Alt   : Float;        --Aircraft altitude, Feet MSL
         Thdg  : Heading_Type; --Aircraft true heading, degrees
         Pitch : Float;        --Aircraft pitch angle (+Up)
         Roll  : Float;        --Aircraft roll angle (+Right Wing Down)
      end record;

   for Ac_Struct_Type use
      record
         Lat   at    0 range 0 .. 63;
         Lon   at    8 range 0 .. 63;
         Alt   at   16 range 0 .. 31;
         Thdg  at   20 range 0 .. 31;
         Pitch at   24 range 0 .. 31;
         Roll  at   28 range 0 .. 31;
      end record;

   type Pac_Struct_Type is access Ac_Struct_Type;

end JPATS_Radio_Db_IF_Types;
