-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-- DATA SOURCE: Flight Safety Doc. Navigation Database - Overview of Real
--                                 Time Access
-------------------------------------------------------------------------------


with JPATS_Radio_Db_If_Types,
     Interfaces.C;

package JPATS_Radio_Db_If is

   package Jrt renames Jpats_Radio_Db_If_Types;

   function Nav_Station return Jrt.Stn_Struct_Type;
   function Dme_Station return Jrt.Stn_Struct_Type;
   function Uhf_Comm_Station return Jrt.Stn_Struct_Type;
   function Vhf_Comm_Station return Jrt.Stn_Struct_Type;
   function Marker_Station return Jrt.Mrkr_Stn_Struct;

   procedure N_Aptrwy_Srch(Aptrwy : in out Jrt.Aptrwy_Request_Type;
                           Apt    : in out Jrt.Apt_Struct_Type;
                           Rwy    : in out Jrt.Rwy_Struct_Type);
   pragma Import(C, N_Aptrwy_Srch, "n_aptrwy_srch");

   procedure N_Ip_Srch(Ip_request : in out Jrt.Ip_Request_Type;
                       Ip_Struct  : in out Jrt.Ip_Struct_Type);
   pragma Import (C, N_Ip_Srch, "n_ip_srch");

   function Terrain_Elevation return Float;
   function Magnetic_Variation return Float;
   function Magnetic_Variation (Position : in Jrt.Position_Type) return Float;

end JPATS_Radio_Db_IF;

