-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Radio_Db_If.Container;

package body JPATS_Radio_Db_If is

   procedure N_Magvar(Ac  : in out Jrt.Ac_Struct_Type;
                      Var : in out Float);
   pragma Import(C, N_Magvar, "n_magvar");

   function Nav_Station
     return Jrt.Stn_Struct_Type is
   begin
      return Container.This_Subsystem.The_Nav_Station;
   end;

   function Dme_Station
     return Jrt.Stn_Struct_Type is
   begin
      return Container.This_Subsystem.The_Dme_Station;
   end;

   function Uhf_Comm_Station
     return Jrt.Stn_Struct_Type is
   begin
      return Container.This_Subsystem.The_Uhf_Comm_Station;
   end;

   function Vhf_Comm_Station
     return Jrt.Stn_Struct_Type is
   begin
      return Container.This_Subsystem.The_Vhf_Comm_Station;
   end;

   function Marker_Station
     return Jrt.Mrkr_Stn_Struct is
   begin
      return Container.This_Subsystem.The_Marker_Station;
   end;

   function Terrain_Elevation
     return Float is
   begin
      return Container.This_Subsystem.The_Terrain_Elevation;
   end;

   function Magnetic_Variation
     return Float is
   begin
      return Container.This_Subsystem.The_Magnetic_Variation;
   end;

   -- Function to return current magvar on request
   function Magnetic_Variation (Position : in Jrt.Position_Type) return Float is

      Ac : Jrt.Ac_Struct_Type;

   begin

      Ac.Lat   := Position.Latitude;
      Ac.Lon   := Position.Longitude;
      Ac.Alt   := Position.Altitude;
      Ac.Thdg  := 0.0;
      Ac.Pitch := 0.0;
      Ac.Roll  := 0.0;
      N_Magvar(Ac,Container.This_Subsystem.The_Magnetic_Variation);

      return Container.This_Subsystem.The_Magnetic_Variation;

   end Magnetic_Variation;

end JPATS_Radio_Db_If;
