-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  First_Name Middle_Initial Last_Name
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Radio_Db_If.Container,
  Jpats_Ios_Interface,
  Jpats_Radio_Db_If_Types;
with Ada.Characters.Handling;
with Log;

use Ada.Characters.Handling;

package body Jpats_Radio_Db_If.Ios_If is

   Temp_Int : Integer;

   Ios : Container.Ios_Interface_Instance renames Container.This_Ios_Interface;
   package Jrt renames Jpats_Radio_Db_If_Types;

   procedure Set_Station_Kill_Stn_Idnt( pData     : JPATS_IOS_Interface.Set_Value;
                                        Offset1d  : Integer;
                                        Offset2d  : Integer;
                                        Completed : Boolean) is
   begin
      if Offset1d < 4 then
         if Jpats_Ios_Interface.Convert_To_Integer( pData ) = 0 then
            Ios.Station_Kill.Stn_Idnt(Offset1d+1):=' ';
         else
            Ios.Station_Kill.Stn_Idnt(Offset1d+1) :=
              JPATS_IOS_Interface.Convert_To_Character( pData );
         end if;
         Ios.Station_Kill.Stn_Idnt(Offset1d+1) :=
           To_Upper(Ios.Station_Kill.Stn_Idnt(Offset1d+1));
      end if;
   end Set_Station_Kill_Stn_Idnt;

   procedure Set_Station_Kill_Kill_Optn( pData : JPATS_IOS_Interface.Set_Value;
                                         Offset1d  : Integer;
                                         Offset2d  : Integer;
                                         Completed : Boolean) is
   begin
      if Offset1d = 0 then
         Temp_Int :=
           JPATS_IOS_Interface.Convert_To_Integer( pData );
         if Temp_Int /= 0 then
            IOS.Station_Kill.Kill_Optn := Jrt.Mask_Type(Temp_Int);
         else
            IOS.Station_Kill.Kill_Optn := Jrt.Mask_Type(Temp_Int);
            Ios.Station_Kill.Kill_Mode := Jrt.Reset;
         end if;
         Ios.Station_Kill_Was_Set := True;
      end if;
   end Set_Station_Kill_Kill_Optn;

   procedure Set_Station_Kill_Kill_Mode( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      Temp_Int :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
      IOS.Station_Kill.Kill_Mode := Jrt.Kill_Mode_Type'Val(Temp_Int);
      Ios.Station_Kill_Was_Set := True;
   end Set_Station_Kill_Kill_Mode;

   procedure Set_Station_Kill_Mkr_Kill( pData : JPATS_IOS_Interface.Set_Value ) is
   begin
      IOS.Station_Kill.Mkr_Kill :=
        JPATS_IOS_Interface.Convert_To_Integer( pData );
   end Set_Station_Kill_Mkr_Kill;

   procedure Set_Magvar_Latitude ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Magvar_Latitude := JPATS_IOS_Interface.Convert_To_Long_Float( pData );
      Ios.Magvar_Latitude_Was_Set := True;
   end Set_Magvar_Latitude;

   procedure Set_Magvar_Longitude ( Pdata : JPATS_IOS_Interface.Set_Value ) is
   begin
      Ios.Magvar_Longitude := JPATS_IOS_Interface.Convert_To_Long_Float( pData );
      Ios.Magvar_Longitude_Was_Set := True;
   end Set_Magvar_Longitude;

   procedure Register_Ios_Variables  is
   begin
      JPATS_IOS_Interface.Register
        (Name        => "Station_Kill_Kill_Mode",
         Variable    => IOS.Station_Kill.Kill_Mode'address,
         Set_Routine => Set_Station_Kill_Kill_Mode'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Station_Kill_Count",
         Variable    => IOS.Station_Kill_Count'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Station_Kill_Mkr_Kill",
         Variable    => IOS.Station_Kill.Mkr_Kill'address,
         Set_Routine => Set_Station_Kill_Mkr_Kill'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Magvar_Latitude",
         Variable    => IOS.Magvar_Latitude'address,
         Set_Routine => Set_Magvar_Latitude'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Magvar_Longitude",
         Variable    => IOS.Magvar_Longitude'address,
         Set_Routine => Set_Magvar_Longitude'access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Local_Magvar",
         Variable    => IOS.Local_Magvar'address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Magnetic_Variation",
         Variable    => IOS.Magnetic_Variation'address
         );

   end Register_Ios_Variables;


end Jpats_Radio_Db_If.Ios_If;
