-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package JPATS_Radio_Db_IF.Container is

   type Instance is
      record
         The_Nav_Station        : Jrt.Stn_Struct_Type;
         The_Dme_Station        : Jrt.Stn_Struct_Type;
         The_Uhf_Comm_Station   : Jrt.Stn_Struct_Type;
         The_Vhf_Comm_Station   : Jrt.Stn_Struct_Type;
         The_Marker_Station     : Jrt.Mrkr_Stn_Struct;
         The_Terrain_Elevation  : Float;
         The_Magnetic_Variation : Float;
      end record;

   This_Subsystem : Instance;

   type Ios_Interface_Instance is
      record
         Station_Kill_Stn_Idnt  : String (1 .. 4*16);
         Station_Kill_Kill_Optn : Jrt.Mask_Array_Type;
         Station_Kill           : Jrt.Stn_Kill_Request_Type;
         Station_Kill_Was_Set   : Boolean;
         Station_Kill_Count     : Integer;
         Magvar_Latitude        : Jrt.Lat_Type;
         Magvar_Longitude       : Jrt.Lon_Type;
         Magnetic_Variation     : Float;
         Magvar_Latitude_Was_Set  : Boolean := False;
         Magvar_Longitude_Was_Set : Boolean := False;
         Local_Magvar           : Float;
      end record;

   This_Ios_Interface : Ios_Interface_Instance;

end JPATS_Radio_Db_IF.Container;
