-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types,
  Jpats_Radio_Db_If_Types;

package VOR is

   type Instance is private;

   procedure Set_VOR_Inputs
     (An_Instance        : in out Instance;
      Power              : in     Boolean;
      Mode_On            : in     Boolean;
      Aircraft_Position  : in     Radio_Types.Position_Type;
      Course_Selected    : in     Radio_Types.Bearing_Type;
      Station            : in     Jpats_Radio_Db_If_Types.Stn_Struct_Type;
      Frequency_Changed  : in     Boolean);

   function Audio_On
     (An_Instance : in Instance)
      return Boolean;

   function To_From_Flag
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type;

   function Valid
     (An_Instance : in Instance)
      return Boolean;

   function VCA
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Mag_Brg_Deg
     (An_Instance : in Instance)
      return Radio_Types.Bearing_Type;

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in Float;
                    An_Instance          : in out Instance);

private

   type Instance is
      record
         Power                      : Boolean;
         Mode_On                    : Boolean;
         Aircraft_Position          : Radio_Types.Position_Type;
         Course_Selected            : Radio_Types.Bearing_Type;
         Station                    : Jpats_Radio_Db_If_Types.Stn_Struct_Type;
         Frequency_Changed          : Boolean;
         Audio_On                   : Boolean;
         To_From_Flag               : Radio_Types.Normalized_Type;
         Dev_Dots                   : Radio_Types.Dots_Type;
         Valid                      : Boolean;
         VCA                        : Radio_Types.Normalized_Type;
         Receiving                  : Boolean;
         Mag_Brg_Deg                : Radio_Types.Bearing_Type;
      end record;

end VOR;
