-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types,
  Jpats_Radio_Types,
  Jpats_Radio_Db_If_Types;

with Radio.Audio,
     Vor,
     Ils,
     Marker_Beacon;

package VHF_Nav is

   type Instance is new Radio.Audio.Instance with private;

   procedure Set_ILS_Freq_Tuned
     (An_Instance    : in out Instance;
      ILS_Freq_Tuned : in     Boolean);

   procedure Set_To_From_Flag
     (An_Instance  : in out Instance;
      To_From_Flag : in     Radio_Types.Normalized_Type);

   procedure Set_Aircraft_True_Hdg
     (An_Instance       : in out Instance;
      Aircraft_True_Hdg : in     Radio_Types.Heading_Type);

   procedure Set_Course_Selected
     (An_Instance     : in out Instance;
      Course_Selected : in     Radio_Types.Bearing_Type);

   procedure Set_Mag_Brg_Deg
     (An_Instance : in out Instance;
      Mag_Brg_Deg : in     Radio_Types.Bearing_Type);

   procedure Set_High_Sense
     (An_Instance : in out Instance;
      High_Sense  : in     Boolean);

   procedure Set_Marker_Station
     (An_Instance    : in out Instance;
      Marker_Station : in     Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct);

   procedure Set_Aircraft_Pitch
     (An_Instance    : in out Instance;
      Aircraft_Pitch : in     Float);

   procedure Set_Reference_Airfield
     (An_Instance        : in out Instance;
      Reference_Airfield : in     Jpats_Radio_Db_If_Types.Apt_Struct_Type);

   procedure Set_Reference_Runway
     (An_Instance      : in out Instance;
      Reference_Runway : in     Jpats_Radio_Db_If_Types.Rwy_Struct_Type);

   procedure Set_Center_Of_Gravity_X
     (An_Instance         : in out Instance;
      Center_Of_Gravity_X : in     Float);

   procedure Set_Center_Of_Gravity_Z
     (An_Instance         : in out Instance;
      Center_Of_Gravity_Z : in     Float);

   procedure Set_Inner_Marker_Vca
     (An_Instance       : in out Instance;
      Inner_Marker_Vca  : in     Float);

   procedure Set_Middle_Marker_Vca
     (An_Instance        : in out Instance;
      Middle_Marker_Vca  : in     Float);

   procedure Set_Outer_Marker_Vca
     (An_Instance       : in out Instance;
      Outer_Marker_Vca  : in     Float);

   procedure Set_Inner_Marker_Receiving
     (An_Instance      : in out Instance;
      Inner_Marker_Receiving : in     Boolean);

   procedure Set_Middle_Marker_Receiving
     (An_Instance             : in out Instance;
      Middle_Marker_Receiving : in     Boolean);

   procedure Set_Outer_Marker_Receiving
     (An_Instance            : in out Instance;
      Outer_Marker_Receiving : in     Boolean);

   procedure Set_Localizer_Dev_Dots
     (An_Instance        : in out Instance;
      Localizer_Dev_Dots : in     Radio_Types.Dots_Type);

   procedure Set_Glideslope_Dev_Dots
     (An_Instance         : in out Instance;
      Glideslope_Dev_Dots : in     Radio_Types.Dots_Type);

   procedure Set_Vor_Receiving
     (An_Instance   : in out Instance;
      Vor_Receiving : in     Boolean);

   procedure Set_Localizer_Receiving
     (An_Instance         : in out Instance;
      Localizer_Receiving : in     Boolean);

   procedure Set_Glideslope_Receiving
     (An_Instance          : in out Instance;
      Glideslope_Receiving : in     Boolean);

   procedure Set_Vor_Valid
     (An_Instance : in out Instance;
      Vor_Valid   : in     Boolean);

   procedure Set_Localizer_Valid
     (An_Instance     : in out Instance;
      Localizer_Valid : in     Boolean);

   procedure Set_Glideslope_Valid
     (An_Instance      : in out Instance;
      Glideslope_Valid : in     Boolean);

   function ILS_Freq_Tuned
     (An_Instance : in Instance)
      return Boolean;

   function To_From_Flag
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function Aircraft_True_Hdg
     (An_Instance : in Instance)
      return Radio_Types.Heading_Type;

   function Course_Selected
     (An_Instance : in Instance)
      return Radio_Types.Bearing_Type;

   function Mag_Brg_Deg
     (An_Instance : in Instance)
      return Radio_Types.Bearing_Type;

   function High_Sense
     (An_Instance : in Instance)
      return Boolean;

   function Marker_Station
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct;

   function Aircraft_Pitch
     (An_Instance : in Instance)
      return Float;

   function Reference_Airfield
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Apt_Struct_Type;

   function Reference_Runway
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Rwy_Struct_Type;

   function Center_Of_Gravity_X
     (An_Instance : in Instance)
      return Float;

   function Center_Of_Gravity_Z
     (An_Instance : in Instance)
      return Float;

   function Inner_Marker_Vca
     (An_Instance : in Instance)
      return Float;

   function Middle_Marker_Vca
     (An_Instance : in Instance)
      return Float;

   function Outer_Marker_Vca
     (An_Instance : in Instance)
      return Float;

   function Inner_Marker_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Middle_Marker_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Outer_Marker_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Localizer_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type;

   function Glideslope_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type;

   function Vor_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Localizer_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Glideslope_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Vor_Valid
     (An_Instance : in Instance)
     return Boolean;

   function Localizer_Valid
     (An_Instance : in Instance)
     return Boolean;

   function Glideslope_Valid
     (An_Instance : in Instance)
     return Boolean;

   function The_Vor
     (An_Instance : in Instance)
     return Vor.Instance;

   function The_Ils
     (An_Instance : in Instance)
     return Ils.Instance;

   function The_Marker_Beacon
     (An_Instance : in Instance)
     return Marker_Beacon.Instance;

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);


private

   type Instance is new Radio.Audio.Instance with
      record
         ILS_Freq_Tuned          : Boolean;
         To_From_Flag            : Radio_Types.Normalized_Type;
         Aircraft_True_Hdg       : Radio_Types.Heading_Type;
         Course_Selected         : Radio_Types.Bearing_Type;
         Mag_Brg_Deg             : Radio_Types.Bearing_Type;
         High_Sense              : Boolean;
         Marker_Station          : Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct;
         Aircraft_Pitch          : Float;
         Reference_Airfield      : Jpats_Radio_Db_If_Types.Apt_Struct_Type;
         Reference_Runway        : Jpats_Radio_Db_If_Types.Rwy_Struct_Type;
         Center_Of_Gravity_X     : Float;
         Center_Of_Gravity_Z     : Float;
         Inner_Marker_Vca        : Float;
         Middle_Marker_Vca       : Float;
         Outer_Marker_Vca        : Float;
         Inner_Marker_Receiving  : Boolean;
         Middle_Marker_Receiving : Boolean;
         Outer_Marker_Receiving  : Boolean;
         Localizer_Dev_Dots      : Radio_Types.Dots_Type;
         Glideslope_Dev_Dots     : Radio_Types.Dots_Type;
         Vor_Receiving           : Boolean;
         Localizer_Receiving     : Boolean;
         Glideslope_Receiving    : Boolean;
         Vor_Valid               : Boolean;
         Localizer_Valid         : Boolean;
         Glideslope_Valid        : Boolean;
         The_VOR                 : VOR.Instance;
         The_Ils                 : ILS.Instance;
         The_Marker_Beacon       : Marker_Beacon.Instance;
      end record;

end VHF_Nav;
