-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Ada.Text_IO,Log;

use Ada.Text_IO,Log;

package body VHF_Nav is

   procedure Set_ILS_Freq_Tuned
     (An_Instance    : in out Instance;
      ILS_Freq_Tuned : in     Boolean) is
   begin
      An_Instance.ILS_Freq_Tuned := ILS_Freq_Tuned;
   end;

   procedure Set_To_From_Flag
     (An_Instance  : in out Instance;
      To_From_Flag : in     Radio_Types.Normalized_Type) is
   begin
      An_Instance.To_From_Flag := To_From_Flag;
   end;

   procedure Set_Aircraft_True_Hdg
     (An_Instance       : in out Instance;
      Aircraft_True_Hdg : in     Radio_Types.Heading_Type) is
   begin
      An_Instance.Aircraft_True_Hdg := Aircraft_True_Hdg;
   end;

   procedure Set_Course_Selected
     (An_Instance     : in out Instance;
      Course_Selected : in     Radio_Types.Bearing_Type) is
   begin
      An_Instance.Course_Selected := Course_Selected;
   end;

   procedure Set_Mag_Brg_Deg
     (An_Instance : in out Instance;
      Mag_Brg_Deg : in     Radio_Types.Bearing_Type) is
   begin
      An_Instance.Mag_Brg_Deg := Mag_Brg_Deg;
   end;

   procedure Set_High_Sense
     (An_Instance : in out Instance;
      High_Sense  : in     Boolean) is
   begin
      An_Instance.High_Sense := High_Sense;
   end;

   procedure Set_Marker_Station
     (An_Instance    : in out Instance;
      Marker_Station : in     Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct) is
   begin
      An_Instance.Marker_Station := Marker_Station;
   end;

   procedure Set_Aircraft_Pitch
     (An_Instance    : in out Instance;
      Aircraft_Pitch : in     Float) is
   begin
      An_Instance.Aircraft_Pitch := Aircraft_Pitch;
   end;

   procedure Set_Reference_Airfield
     (An_Instance        : in out Instance;
      Reference_Airfield : in     Jpats_Radio_Db_If_Types.Apt_Struct_Type) is
   begin
      An_Instance.Reference_Airfield := Reference_Airfield;
   end;

   procedure Set_Reference_Runway
     (An_Instance      : in out Instance;
      Reference_Runway : in     Jpats_Radio_Db_If_Types.Rwy_Struct_Type) is
   begin
      An_Instance.Reference_Runway := Reference_Runway;
   end;

   procedure Set_Center_Of_Gravity_X
     (An_Instance         : in out Instance;
      Center_Of_Gravity_X : in     Float) is
   begin
      An_Instance.Center_Of_Gravity_X := Center_Of_Gravity_X;
   end;

   procedure Set_Center_Of_Gravity_Z
     (An_Instance         : in out Instance;
      Center_Of_Gravity_Z : in     Float) is
   begin
      An_Instance.Center_Of_Gravity_Z := Center_Of_Gravity_Z;
   end;

   procedure Set_Inner_Marker_Vca
     (An_Instance      : in out Instance;
      Inner_Marker_Vca : in     Float) is
   begin
      An_Instance.Inner_Marker_Vca := Inner_Marker_Vca;
   end;
   procedure Set_Middle_Marker_Vca
     (An_Instance       : in out Instance;
      Middle_Marker_Vca : in     Float) is
   begin
      An_Instance.Middle_Marker_Vca := Middle_Marker_Vca;
   end;
   procedure Set_Outer_Marker_Vca
     (An_Instance      : in out Instance;
      Outer_Marker_Vca : in     Float) is
   begin
      An_Instance.Outer_Marker_Vca := Outer_Marker_Vca;
   end;

   procedure Set_Inner_Marker_Receiving
     (An_Instance      : in out Instance;
      Inner_Marker_Receiving : in     Boolean) is
   begin
      An_Instance.Inner_Marker_Receiving := Inner_Marker_Receiving;
   end;

   procedure Set_Middle_Marker_Receiving
     (An_Instance             : in out Instance;
      Middle_Marker_Receiving : in     Boolean) is
   begin
      An_Instance.Middle_Marker_Receiving := Middle_Marker_Receiving;
   end;

   procedure Set_Outer_Marker_Receiving
     (An_Instance            : in out Instance;
      Outer_Marker_Receiving : in     Boolean) is
   begin
      An_Instance.Outer_Marker_Receiving := Outer_Marker_Receiving;
   end;

   procedure Set_Localizer_Dev_Dots
     (An_Instance        : in out Instance;
      Localizer_Dev_Dots : in     Radio_Types.Dots_Type) is
   begin
      An_Instance.Localizer_Dev_Dots := Localizer_Dev_Dots;
   end;

   procedure Set_Glideslope_Dev_Dots
     (An_Instance         : in out Instance;
      Glideslope_Dev_Dots : in     Radio_Types.Dots_Type) is
   begin
      An_Instance.Glideslope_Dev_Dots := Glideslope_Dev_Dots;
   end;

   procedure Set_Vor_Receiving
     (An_Instance   : in out Instance;
      Vor_Receiving : in     Boolean) is
   begin
      An_Instance.Vor_Receiving := Vor_Receiving;
   end;

   procedure Set_Localizer_Receiving
     (An_Instance         : in out Instance;
      Localizer_Receiving : in     Boolean) is
   begin
      An_Instance.Localizer_Receiving := Localizer_Receiving;
   end;

   procedure Set_Glideslope_Receiving
     (An_Instance          : in out Instance;
      Glideslope_Receiving : in     Boolean) is
   begin
      An_Instance.Glideslope_Receiving := Glideslope_Receiving;
   end;

   procedure Set_Vor_Valid
     (An_Instance : in out Instance;
      Vor_Valid   : in     Boolean) is
   begin
      An_Instance.Vor_Valid := Vor_Valid;
   end;

   procedure Set_Localizer_Valid
     (An_Instance     : in out Instance;
      Localizer_Valid : in     Boolean) is
   begin
      An_Instance.Localizer_Valid := Localizer_Valid;
   end;
   procedure Set_Glideslope_Valid
     (An_Instance      : in out Instance;
      Glideslope_Valid : in     Boolean) is
   begin
      An_Instance.Glideslope_Valid := Glideslope_Valid;
   end;

   function ILS_Freq_Tuned
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.ILS_Freq_Tuned;
   end;

   function To_From_Flag
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type is
   begin
      return An_Instance.To_From_Flag;
   end;

   function Aircraft_True_Hdg
     (An_Instance : in Instance)
      return Radio_Types.Heading_Type is
   begin
      return An_Instance.Aircraft_True_Hdg;
   end;

   function Course_Selected
     (An_Instance : in Instance)
      return Radio_Types.Bearing_Type is
   begin
      return An_Instance.Course_Selected;
   end;

   function Mag_Brg_Deg
     (An_Instance : in Instance)
      return Radio_Types.Bearing_Type is
   begin
      return An_Instance.Mag_Brg_Deg;
   end;

   function High_Sense
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.High_Sense;
   end;

   function Marker_Station
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct is
   begin
      return An_Instance.Marker_Station;
   end;

   function Aircraft_Pitch
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Aircraft_Pitch;
   end;

   function Reference_Airfield
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Apt_Struct_Type is
   begin
      return An_Instance.Reference_Airfield;
   end;

   function Reference_Runway
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Rwy_Struct_Type is
   begin
      return An_Instance.Reference_Runway;
   end;

   function Center_Of_Gravity_X
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Center_Of_Gravity_X;
   end;

   function Center_Of_Gravity_Z
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Center_Of_Gravity_Z;
   end;

   function Inner_Marker_Vca
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Inner_Marker_Vca;
   end;

   function Middle_Marker_Vca
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Middle_Marker_Vca;
   end;

   function Outer_Marker_Vca
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Outer_Marker_Vca;
   end;

   function Inner_Marker_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Inner_Marker_Receiving;
   end;

   function Middle_Marker_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Middle_Marker_Receiving;
   end;

   function Outer_Marker_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Outer_Marker_Receiving;
   end;

   function Localizer_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type is
   begin
      return An_Instance.Localizer_Dev_Dots;
   end;

   function Glideslope_Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type is
   begin
      return An_Instance.Glideslope_Dev_Dots;
   end;

   function Vor_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Vor_Receiving;
   end;

   function Localizer_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Localizer_Receiving;
   end;

   function Glideslope_Receiving
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Glideslope_Receiving;
   end;

   function Vor_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Vor_Valid;
   end;

   function Localizer_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Localizer_Valid;
   end;

   function Glideslope_Valid
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Glideslope_Valid;
   end;

   function The_Vor
     (An_Instance : in Instance)
     return Vor.Instance is
   begin
      return
        An_Instance.The_Vor;
   end;

   function The_Ils
     (An_Instance : in Instance)
     return Ils.Instance is
   begin
      return
        An_Instance.The_Ils;
   end;

   function The_Marker_Beacon
     (An_Instance : in Instance)
     return Marker_Beacon.Instance is
   begin
      return
        An_Instance.The_Marker_Beacon;
   end;

-----------------------------------------------------------------------------
   procedure Init(An_Instance : in out Instance) is

   begin

      --initialize the vor
      Vor.Init(An_Instance.The_Vor);

      --initialize the ILS
      Ils.Init(An_Instance.The_Ils);

      --initialize the Marker Beacon
      Marker_Beacon.Init(An_Instance.The_Marker_Beacon);

      An_Instance.ILS_Freq_Tuned    := false;
      An_Instance.To_From_Flag      := 0.0;
      An_Instance.Aircraft_True_Hdg := 0.0;
      An_Instance.Course_Selected   := 0.0;
      An_Instance.Mag_Brg_Deg       := 0.0;
      An_Instance.High_Sense        := true;

   end;

---------------------------------------------------------------------------

   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance) is

   begin

      --The following will be called dependent upon frequencies selected, mode switch, etc.
      if An_Instance.Ils_Freq_Tuned then

         --Provide inputs to ILS for processing:
         Ils.Set_Power(An_Instance.The_ILS,Power(An_Instance));
         Ils.Set_Mode_On(An_Instance.The_ILS,Mode_On(An_Instance));
         Ils.Set_Aircraft_True_Hdg(An_Instance.The_ILS,
                                   Aircraft_True_Hdg(An_Instance));
         Ils.Set_Aircraft_Position(An_Instance.The_ILS,
                                   Aircraft_Position(An_Instance));
         Ils.Set_Station(An_Instance.The_ILS,Station(An_Instance));
         Ils.Set_Center_Of_Gravity_X(An_Instance.The_ILS,
                                     Center_Of_Gravity_X(An_Instance));
         Ils.Set_Center_Of_Gravity_Z(An_Instance.The_ILS,
                                     Center_Of_Gravity_Z(An_Instance));
         Ils.Set_Aircraft_Pitch(An_Instance.The_ILS,
                                Aircraft_Pitch(An_Instance));
         Ils.Set_Reference_Airfield(An_Instance.The_Ils,
                                    Reference_Airfield(An_Instance));
         Ils.Set_Reference_Runway(An_Instance.The_Ils,
                                  Reference_Runway(An_Instance));


         --Call ILS
         ILS.Update(Integration_Constant, An_Instance.The_ILS);

         --Get outputs from ILS
         Set_Audio_On(An_Instance,ILS.Audio_On(An_Instance.The_ILS));
         Set_To_From_Flag(An_Instance,ILS.To_From_Flag(An_Instance.The_ILS));
         Set_Vor_Valid(An_Instance,False);
         Set_Localizer_Valid(An_Instance,
                             ILS.Localizer_Valid(An_Instance.The_ILS));
         Set_Glideslope_Valid(An_Instance,
                              ILS.Glideslope_Valid(An_Instance.The_ILS));
         Set_VCA(An_Instance,ILS.VCA(An_Instance.The_ILS));
         Set_Vor_Receiving(An_Instance,False);
         Set_Localizer_Receiving(An_Instance,
                                 ILS.Localizer_Receiving(An_Instance.The_ILS));
         Set_Glideslope_Receiving(An_Instance,
                                ILS.Glideslope_Receiving(An_Instance.The_ILS));
         Set_Localizer_Dev_Dots(An_Instance,
                                ILS.Localizer_Dev_Dots(An_Instance.The_ILS));
         Set_Glideslope_Dev_Dots(An_Instance,
                                 ILS.Glideslope_Dev_Dots(An_Instance.The_ILS));
         Set_Mag_Brg_Deg(An_Instance,90.0);

      --VOR frequency tuned
      else

         --Provide inputs to VOR for processing:
         VOR.Set_VOR_Inputs
           (An_Instance        => An_Instance.The_VOR,
            Power              => Power(An_Instance),
            Mode_On            => Mode_On(An_Instance),
            Aircraft_Position  => Aircraft_Position(An_Instance),
            Course_Selected    => Course_Selected(An_Instance),
            Station            => Station(An_Instance),
            Frequency_Changed  => Frequency_Changed(An_Instance));

         --Call VOR
         VOR.Update(Integration_Constant, An_Instance.The_VOR);

         --Get outputs from VOR
         Set_Audio_On(An_Instance,VOR.Audio_On(An_Instance.The_VOR));
         Set_To_From_Flag(An_Instance,VOR.To_From_Flag(An_Instance.The_VOR));
         Set_Vor_Valid(An_Instance,VOR.Valid(An_Instance.The_VOR));
         Set_Localizer_Valid(An_Instance,False);
         Set_Glideslope_Valid(An_Instance,False);
         Set_VCA(An_Instance,VOR.VCA(An_Instance.The_VOR));
         Set_Vor_Receiving(An_Instance,VOR.Receiving(An_Instance.The_VOR));
         Set_Localizer_Receiving(An_Instance,False);
         Set_Glideslope_Receiving(An_Instance,False);
         Set_Localizer_Dev_Dots(An_Instance,0.0);
         Set_Glideslope_Dev_Dots(An_Instance,0.0);
         Set_Mag_Brg_Deg(An_Instance,VOR.Mag_Brg_Deg(An_Instance.The_VOR));

      end if;


      --Provide inputs to Marker Beacon for processing:
      Marker_Beacon.Set_Power(An_Instance.The_Marker_Beacon,
                              Power(An_Instance));
      Marker_Beacon.Set_High_Sense(An_Instance.The_Marker_Beacon,
                                   High_Sense(An_Instance));
      Marker_Beacon.Set_Aircraft_Position(An_Instance.The_Marker_Beacon,
                                          Aircraft_Position(An_Instance));
      Marker_Beacon.Set_Station(An_Instance.The_Marker_Beacon,
                                Marker_Station(An_Instance));

      --Call Marker Beacon
      Marker_Beacon.Update(Integration_Constant,An_Instance.The_Marker_Beacon);

      --Get outputs from Marker Beacon
      Set_Inner_Marker_VCA(An_Instance,
              Marker_Beacon.Inner_VCA(An_Instance.The_Marker_Beacon));
      Set_Middle_Marker_VCA(An_Instance,
              Marker_Beacon.Middle_VCA(An_Instance.The_Marker_Beacon));
      Set_Outer_Marker_VCA(An_Instance,
              Marker_Beacon.Outer_VCA(An_Instance.The_Marker_Beacon));
      Set_Inner_Marker_Receiving(An_Instance,
         Marker_Beacon.Inner_Receiving(An_Instance.The_Marker_Beacon));
      Set_Middle_Marker_Receiving(An_Instance,
         Marker_Beacon.Middle_Receiving(An_Instance.The_Marker_Beacon));
      Set_Outer_Marker_Receiving(An_Instance,
         Marker_Beacon.Outer_Receiving(An_Instance.The_Marker_Beacon));

   end Update;

end VHF_Nav;
