-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Radio_Db_If_Types;
with Angle_Types;

package Radio_Utilities is

   package Dbt renames Jpats_Radio_Db_If_Types;

-----------------------------------------------------------------------------

   function xn180(BRG : Float) return Float renames Angle_Types.Normalize_Degrees_180;

-----------------------------------------------------------------------------

   function Xn180(Brg : Long_Float) return Long_Float;

-----------------------------------------------------------------------------

   function flimit(VALUE : Float;
                   MIN   : Float;
                   MAX   : Float) return Float;

------------------------------------------------------------------------------


   function flimit(VALUE : Integer;
                   MIN   : Integer;
                   MAX   : Integer) return Integer;

------------------------------------------------------------------------------

   --Outer Marker Model
   function Om_Model(Agas_In : Float;
                     Bgas_In : Float;
                     Zgas_In : Float) return Float;

------------------------------------------------------------------------------

   --Middle Marker Model
   function Mm_Model(Agas_In : Float;
                     Bgas_In : Float;
                     Zgas_In : Float) return Float;

------------------------------------------------------------------------------

   --Inner Marker Model
   function Im_Model(Agas_In       : Float;
                     Bgas_In       : Float;
                     Zgas_In       : Float;
                     Station_Type2 : Dbt.Bitfield) return Float;

------------------------------------------------------------------------------


end Radio_Utilities;

