-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------


with Radio_Types;

package Radio is

   type Instance is tagged private;

   procedure Set_Power
      (An_Instance : in out Instance;
       Power       : in     Boolean);

   procedure Set_Mode_On
      (An_Instance : in out Instance;
       Mode_On     : in     Boolean);

   procedure Set_Aircraft_Position
      (An_Instance       : in out Instance;
       Aircraft_Position : in     Radio_Types.Position_Type);

   procedure Set_Ground_Elevation
      (An_Instance      : in out Instance;
       Ground_Elevation : in     Radio_Types.Altitude_Type);

   procedure Set_Valid
      (An_Instance : in out Instance;
       Valid       : in     Boolean);

   function Power
      (An_Instance : in Instance)
       return Boolean;

   function Mode_On
      (An_Instance : in Instance)
       return Boolean;

   function Aircraft_Position
      (An_Instance : in Instance)
       return Radio_Types.Position_Type;

   function Ground_Elevation
      (An_Instance : in Instance)
       return Radio_Types.Altitude_Type;

   function Valid
      (An_Instance : in Instance)
       return Boolean;


private

   type Instance is tagged
      record
         Power                      : Boolean;
         Mode_On                    : Boolean;
         Aircraft_Position          : Radio_Types.Position_Type;
         Ground_Elevation           : Radio_Types.Altitude_Type;
         Valid                      : Boolean;
      end record;


end Radio;
