-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Avionics_Types;

package Radio.Transponder is

   type Instance is new Radio.Instance with private;

   procedure Set_Mode_Sel
     (An_Instance : in out Instance;
      Mode_Sel    : in     Jpats_Avionics_Types.Xpdr_Mode_Select_Type);

   procedure Set_Mode_Current
     (An_Instance  : in out Instance;
      Mode_Current : in     Jpats_Avionics_Types.Xpdr_Mode_Select_Type);

   procedure Set_Ident_Sel
     (An_Instance : in out Instance;
      Ident_Sel   : in     Boolean);

   procedure Set_Ident_Current
     (An_Instance   : in out Instance;
      Ident_Current : in     Boolean);

   procedure Set_Test_Sel
     (An_Instance : in out Instance;
      Test_Sel    : in     Boolean);

   procedure Set_Test_Current
     (An_Instance  : in out Instance;
      Test_Current : in     Boolean);

   procedure Set_Alt_Reporting
     (An_Instance   : in out Instance;
      Alt_Reporting : in     Boolean);

   function Mode_Sel
     (An_Instance : in Instance)
      return Jpats_Avionics_Types.Xpdr_Mode_Select_Type;

   function Mode_Current
     (An_Instance : in Instance)
      return Jpats_Avionics_Types.Xpdr_Mode_Select_Type;

   function Ident_Sel
     (An_Instance : in Instance)
      return Boolean;

   function Ident_Current
     (An_Instance : in Instance)
      return Boolean;

   function Test_Sel
     (An_Instance : in Instance)
      return Boolean;

   function Test_Current
     (An_Instance : in Instance)
      return Boolean;

   function Alt_Reporting
     (An_Instance : in Instance)
      return Boolean;

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);

private

   type Instance is new Radio.Instance with
      record
         Mode_Sel          : Jpats_Avionics_Types.Xpdr_Mode_Select_Type;
         Ident_Sel         : Boolean;
         Test_Sel          : Boolean;
         Mode_Current      : Jpats_Avionics_Types.Xpdr_Mode_Select_Type;
         Ident_Current     : Boolean;
         Test_Current      : Boolean;
         Alt_Reporting     : Boolean;
      end record;

end Radio.Transponder;
