-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Avionics_Types;
use Jpats_Avionics_Types;

package body Radio.Transponder is

   Flash_1 : Float;
   Flash_2 : Float;
   Reply   : Boolean;

   procedure Set_Mode_Sel
     (An_Instance : in out Instance;
      Mode_Sel    : in     Jpats_Avionics_Types.Xpdr_Mode_Select_Type) is
   begin
      An_Instance.Mode_Sel := Mode_Sel;
   end;

   procedure Set_Mode_Current
     (An_Instance  : in out Instance;
      Mode_Current : in     Jpats_Avionics_Types.Xpdr_Mode_Select_Type) is
   begin
      An_Instance.Mode_Current := Mode_Current;
   end;

   procedure Set_Ident_Sel
     (An_Instance : in out Instance;
      Ident_Sel   : in     Boolean) is
   begin
      An_Instance.Ident_Sel := Ident_Sel;
   end;

   procedure Set_Ident_Current
     (An_Instance   : in out Instance;
      Ident_Current : in     Boolean) is
   begin
      An_Instance.Ident_Current := Ident_Current;
   end;

   procedure Set_Test_Sel
     (An_Instance : in out Instance;
      Test_Sel    : in     Boolean) is
   begin
      An_Instance.Test_Sel := Test_Sel;
   end;

   procedure Set_Test_Current
     (An_Instance  : in out Instance;
      Test_Current : in     Boolean) is
   begin
      An_Instance.Test_Current := Test_Current;
   end;

   procedure Set_Alt_Reporting
     (An_Instance   : in out Instance;
      Alt_Reporting : in     Boolean) is
   begin
      An_Instance.Alt_Reporting := Alt_Reporting;
   end;

   function Mode_Sel
     (An_Instance : in Instance)
      return Jpats_Avionics_Types.Xpdr_Mode_Select_Type is
   begin
      return An_Instance.Mode_Sel;
   end;

   function Mode_Current
     (An_Instance : in Instance)
      return Jpats_Avionics_Types.Xpdr_Mode_Select_Type is
   begin
      return An_Instance.Mode_Current;
   end;

   function Ident_Sel
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Ident_Sel;
   end;

   function Ident_Current
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Ident_Current;
   end;

   function Test_Sel
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Test_Sel;
   end;

   function Test_Current
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Test_Current;
   end;

   function Alt_Reporting
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Alt_Reporting;
   end;

-- =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =

   procedure INIT(An_Instance : in out Instance) is

   begin

      -- Initialize instance components:
      An_Instance.Mode_Sel      := Jpats_Avionics_Types.Stby;
      An_Instance.Mode_Current  := Jpats_Avionics_Types.Stby;
      An_Instance.Ident_Sel     := False;
      An_Instance.Test_Sel      := False;
      An_Instance.Ident_Current := False;
      An_Instance.Test_Current  := False;
      An_Instance.Alt_Reporting := False;
   end Init;

-- =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =
   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance) is

   begin

--*********************************************************************
--*># GROUND STATION INTERROGATIONS                                   *
--*********************************************************************
--*>
--*> Two seperate flash counters are used, each with a different
--*> timing constant, to give the reply effect from the ground
--*> stations on the transponders control head reply light.
--*>
      Flash_1 := Flash_1 + Integration_Constant;
      if Flash_1 > 5.0 then Flash_1 := 0.0; end if;

      Flash_2 := Flash_2 + Integration_Constant;
      if Flash_1 > 12.0 then Flash_2 := 0.0; end if;

--*********************************************************************
--*># TRANSPONDER VALIDS                                              *
--*********************************************************************
--*>
--*> The validity of the transponder system is determined from the
--*> transponders power and the availability of data from the
--*> control head for each transponder system.
--*>
      if An_Instance.Power then
         An_Instance.Valid := True;
         An_Instance.Mode_Current := An_Instance.Mode_Sel;
      else
         An_Instance.Valid         := False;
         An_Instance.Mode_Current  := Jpats_Avionics_Types.Stby;
         An_Instance.Test_Current  := False;
         An_Instance.Ident_Current := False;
         Reply                     := False;
      end if;

      --Transponder valid
      if An_Instance.Valid then

--*********************************************************************
--*># ALTITUDE ENCODING                                               *
--*********************************************************************
--*>
--*> The altitude reporting is selected from the rtu's.  From the
--*> unpacked beacon code data above, the proper altitude reporting
--*> flags are checked to determine the output of altitude information
--*> from the TDR-94 on the TDR bus(s).
--*>
         An_Instance.Alt_Reporting :=
           An_Instance.Mode_Current = Jpats_Avionics_Types.Alt or
           An_Instance.Mode_Current = Jpats_Avionics_Types.Ta or
           An_Instance.Mode_Current = Jpats_Avionics_Types.Ta_Ra;

--*********************************************************************
--*># TRANSPONDER REPLY AND IDENT OUTPUTS                             *
--*********************************************************************
--*>
--*> The transponder reply is controlled by the flash counters
--*> and normal system logic.  The ident is contolled by the ident
--*> bit in the 429 data and sets the reply for approximately
--*> 15 seconds.
--*>
         An_Instance.Ident_Current := An_Instance.Ident_Sel;

         if An_Instance.Mode_Current /= Jpats_Avionics_Types.Stby and
           not An_Instance.Test_Current then
            Reply := Flash_1 >= 3.5 or Flash_2 >= 10.5;
         else
            Reply := False;
         end if;

      end if;

   end Update;

end Radio.Transponder;
