-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Radio.ELT is

   procedure Set_Arm_Sw
     (An_Instance : in out Instance;
      Arm_Sw      : in     Boolean) is
   begin
      An_Instance.Arm_Sw := Arm_Sw;
   end;

   procedure Set_On_Sw
     (An_Instance : in out Instance;
      On_Sw       : in     Boolean) is
   begin
      An_Instance.On_Sw := On_Sw;
   end;

   procedure Set_Transmit
     (An_Instance : in out Instance;
      Transmit    : in     Boolean) is
   begin
      An_Instance.Transmit := Transmit;
   end;

   procedure Set_Crash
     (An_Instance : in out Instance;
      Crash       : in     Boolean) is
   begin
      An_Instance.Crash := Crash;
   end;

   function Arm_Sw
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Arm_Sw;
   end;

    function On_Sw
      (An_Instance : in Instance)
     return Boolean is
   begin
      return An_Instance.On_Sw;
   end;

   function Transmit
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Transmit;
   end;

   function Crash
     (An_Instance : in Instance)
      return Boolean is
   begin
      return An_Instance.Crash;
   end;

-- =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =

   procedure INIT(An_Instance : in out Instance) is

   begin

      -- Initialize instance components:
      An_Instance.Arm_Sw      := False;
      An_Instance.On_Sw       := False;
      An_Instance.Transmit    := False;
      An_Instance.Crash       := False;

   end Init;

-- =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =
   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance) is

   begin

--*********************************************************************
--*># EMERGENCY LOCATOR TRANSMITTER (ELT)
--*********************************************************************
--*>
--*> Upon activation there is no delay before the ELT starts to transmit.
--*> Activation is indicated by the XMT annunciator.
--*> For Automatic activation, the switch on the emergency panel
--*> shall be in the ARM position.  For Manual activation, the switch
--*> on the emergency panel shall be in the ON position.  It is assumed
--*> the ELT switch (theoretical) is always in the ON/ARMED position,
--*> and battery fully charged.
--*>
      An_Instance.Transmit := An_Instance.On_Sw or
        (An_Instance.Arm_Sw and An_Instance.Crash);


   end Update;


end Radio.ELT;
