-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types,
  Jpats_Radio_Db_If_Types;

package Radio.Audio is

   package Radio_Db renames Jpats_Radio_Db_If_Types;

   type Instance is new Radio.Instance with private;

   procedure Set_VCA
     (An_Instance : in out Instance;
      VCA         : in     Radio_Types.Normalized_Type);

   procedure Set_VCN
     (An_Instance : in out Instance;
      VCN         : in     Radio_Types.Normalized_Type);

   procedure Set_Ident
     (An_Instance : in out Instance;
      Ident       : in     Radio_Types.Ident_Type);

   procedure Set_Receiving
     (An_Instance : in out Instance;
      Receiving   : in     Boolean);

   procedure Set_Test
     (An_Instance : in out Instance;
      Test        : in     Boolean);

   procedure Set_Audio_On
     (An_Instance : in out Instance;
      Audio_On    : in     Boolean);

   procedure Set_Station
     (An_Instance : in out Instance;
      Station     : in     Radio_Db.Stn_Struct_Type);

   procedure Set_Dev_Dots
     (An_Instance : in out Instance;
      Dev_Dots    : in     Radio_Types.Dots_Type);

   procedure Set_Frequency_Changed
     (An_Instance       : in out Instance;
      Frequency_Changed : in     Boolean);

   function VCA
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function VCN
     (An_Instance : in Instance)
      return Radio_Types.Normalized_Type;

   function Ident
     (An_Instance : in Instance)
      return Radio_Types.Ident_Type;

   function Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Test
     (An_Instance : in Instance)
      return Boolean;

   function Audio_On
     (An_Instance : in Instance)
      return Boolean;

   function Station
     (An_Instance : in Instance)
      return Radio_Db.Stn_Struct_Type;

   function Dev_Dots
     (An_Instance : in Instance)
      return Radio_Types.Dots_Type;

   function Frequency_Changed
     (An_Instance : in Instance)
      return Boolean;

private

   type Instance is new Radio.Instance with
      record
         VCA                        : Radio_Types.Normalized_Type;
         VCN                        : Radio_Types.Normalized_Type;
         Ident                      : Radio_Types.Ident_Type;
         Receiving                  : Boolean;
         Test                       : Boolean;
         Audio_On                   : Boolean;
         Station                    : Radio_Db.Stn_Struct_Type;
         Dev_Dots                   : Radio_Types.Dots_Type;
         Frequency_Changed          : Boolean;
      end record;

end Radio.Audio;
