-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
package body Radio.Audio is

   procedure Set_VCA
     (An_Instance : in out Instance;
      VCA         : in     Radio_Types.Normalized_Type) is
   begin
      An_Instance.VCA := VCA;
   end;

   procedure Set_VCN
     (An_Instance : in out Instance;
      VCN         : in     Radio_Types.Normalized_Type) is
   begin
      An_Instance.VCN := VCN;
   end;

   procedure Set_Ident
     (An_Instance : in out Instance;
      Ident       : in     Radio_Types.Ident_Type) is
   begin
      An_Instance.Ident := Ident;
   end;

   procedure Set_Receiving
     (An_Instance : in out Instance;
      Receiving   : in     Boolean) is
   begin
      An_Instance.Receiving := Receiving;
   end;

   procedure Set_Test
     (An_Instance : in out Instance;
      Test       : in     Boolean) is
   begin
      An_Instance.Test := Test;
   end;

   procedure Set_Audio_On
     (An_Instance : in out Instance;
      Audio_On    : in     Boolean) is
   begin
      An_Instance.Audio_On := Audio_On;
   end;

   procedure Set_Station
     (An_Instance : in out Instance;
      Station     : in     Radio_Db.Stn_Struct_Type) is
   begin
      An_Instance.Station := Station;
   end;

   procedure Set_Dev_Dots
     (An_Instance : in out Instance;
      Dev_Dots    : in     Radio_Types.Dots_Type) is
   begin
      An_Instance.Dev_Dots := Dev_Dots;
   end;

   procedure Set_Frequency_Changed
     (An_Instance       : in out Instance;
      Frequency_Changed : in     Boolean) is
   begin
      An_Instance.Frequency_Changed := Frequency_Changed;
   end;

   function VCA
     (An_Instance : in Instance)
     return Radio_Types.Normalized_Type is
   begin
     return An_Instance.VCA;
   end;

   function VCN
     (An_Instance : in Instance)
     return Radio_Types.Normalized_Type is
   begin
     return An_Instance.VCN;
   end;

   function Ident
     (An_Instance : in Instance)
     return Radio_Types.Ident_Type is
   begin
     return An_Instance.Ident;
   end;

   function Receiving
     (An_Instance : in Instance)
     return Boolean is
   begin
     return An_Instance.Receiving;
   end;

   function Test
     (An_Instance : in Instance)
     return Boolean is
   begin
     return An_Instance.Test;
   end;

   function Audio_On
     (An_Instance : in Instance)
     return Boolean is
   begin
     return An_Instance.Audio_On;
   end;

   function Station
     (An_Instance : in Instance)
     return Radio_Db.Stn_Struct_Type is
   begin
     return An_Instance.Station;
   end;

   function Dev_Dots
     (An_Instance : in Instance)
     return Radio_Types.Dots_Type is
   begin
     return An_Instance.Dev_Dots;
   end;

   function Frequency_Changed
     (An_Instance : in Instance)
     return Boolean is
   begin
     return An_Instance.Frequency_Changed;
   end;

end Radio.Audio;
