-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types;

package Radio.Audio.DME is

   type Instance is new Radio.Audio.Instance with private;

   procedure Set_ILS_Freq_Tuned
     (An_Instance    : in out Instance;
      ILS_Freq_Tuned : in     Boolean);

   procedure Set_Frequency_Hold_Selected
     (An_Instance             : in out Instance;
      Frequency_Hold_Selected : in     Boolean);

   procedure Set_Range_To_Station
     (An_Instance      : in out Instance;
      Range_To_Station : in     Radio_Types.Range_Type);

   procedure Set_Knots_Calculated
     (An_Instance      : in out Instance;
      Knots_Calculated : in     Radio_Types.Knots_Type);

   procedure Set_TTS_Calculated
     (An_Instance    : in out Instance;
      TTS_Calculated : in     Radio_Types.Timer_Type);

   procedure Set_Kts_Tts_Valid
     (An_Instance   : in out Instance;
      Kts_Tts_Valid : in     Boolean);

   procedure Set_Dme_Hold
     (An_Instance : in out Instance;
      Dme_Hold    : in     Boolean);

   procedure Set_No_Computed_Data
     (An_Instance      : in out Instance;
      No_Computed_Data : in     Boolean);

   function ILS_Freq_Tuned
     (An_Instance : in Instance)
      return Boolean;

   function Frequency_Hold_Selected
     (An_Instance : in Instance)
      return Boolean;

   function Range_To_Station
     (An_Instance : in Instance)
      return Radio_Types.Range_Type;

   function Knots_Calculated
     (An_Instance : in Instance)
      return Radio_Types.Knots_Type;

   function TTS_Calculated
     (An_Instance : in Instance)
      return Radio_Types.Timer_Type;

   function Kts_Tts_Valid
     (An_Instance : in Instance)
      return Boolean;

   function Dme_Hold
     (An_Instance : in Instance)
      return Boolean;

   function No_Computed_Data
     (An_Instance : in Instance)
      return Boolean;

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);


private

   type Instance is new Radio.Audio.Instance with
      record
         ILS_Freq_Tuned          : Boolean;
         Frequency_Hold_Selected : Boolean;
         Range_To_Station        : Radio_Types.Range_Type;
         Knots_Calculated        : Radio_Types.Knots_Type;
         TTS_Calculated          : Radio_Types.Timer_Type;
         Kts_Tts_Valid           : Boolean;
         Dme_Hold                : Boolean;
         No_Computed_Data        : Boolean;
      end record;

end Radio.Audio.DME;
