-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types;

package Radio.Audio.Communication.Vhf_Comm is

   type Instance is new Communication.Instance with private;

   function Frequency
     (An_Instance : in Instance)
      return Integer;

   function Elt_Transmit
     (An_Instance : in Instance)
      return Boolean;

   procedure Set_Frequency
     (An_Instance : in out Instance;
      Frequency   : in     Integer);

   procedure Set_Elt_Transmit
     (An_Instance  : in out Instance;
      Elt_Transmit : in     Boolean);

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in     Float;
                    An_Instance          : in out Instance);

private

   type Instance is new Communication.Instance with
      record
         Frequency    : Integer;
         Elt_Transmit : Boolean;
      end record;

end Radio.Audio.Communication.Vhf_Comm;
