-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Radio_Types,
  Jpats_Radio_Types,
  Jpats_Radio_Db_If_Types;

package Marker_Beacon is

   type Instance is private;

   procedure Set_Power
     (An_Instance : in out Instance;
      Power       : in     Boolean);

   procedure Set_High_Sense
     (An_Instance : in out Instance;
      High_Sense  : in     Boolean);

   procedure Set_Aircraft_Position
     (An_Instance       : in out Instance;
      Aircraft_Position : in     Radio_Types.Position_Type);

   procedure Set_Station
     (An_Instance : in out Instance;
      Station     : in     Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct);

   procedure Set_Inner_Vca
     (An_Instance : in out Instance;
      Inner_Vca   : in     Float);

   procedure Set_Middle_Vca
     (An_Instance : in out Instance;
      Middle_Vca  : in     Float);

   procedure Set_Outer_Vca
     (An_Instance : in out Instance;
      Outer_Vca   : in     Float);

   procedure Set_Inner_Receiving
     (An_Instance     : in out Instance;
      Inner_Receiving : in     Boolean);

   procedure Set_Middle_Receiving
     (An_Instance      : in out Instance;
      Middle_Receiving : in     Boolean);

   procedure Set_Outer_Receiving
     (An_Instance     : in out Instance;
      Outer_Receiving : in     Boolean);

   function Power
     (An_Instance : in Instance)
      return Boolean;

   function High_Sense
     (An_Instance : in Instance)
      return Boolean;

   function Aircraft_Position
     (An_Instance : in Instance)
      return Radio_Types.Position_Type;

   function Station
     (An_Instance : in Instance)
      return Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct;

   function Inner_Vca
     (An_Instance : in Instance)
      return Float;

   function Middle_Vca
     (An_Instance : in Instance)
      return Float;

   function Outer_Vca
     (An_Instance : in Instance)
      return Float;

   function Inner_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Middle_Receiving
     (An_Instance : in Instance)
      return Boolean;

   function Outer_Receiving
     (An_Instance : in Instance)
      return Boolean;

   procedure Init(An_Instance : in out Instance);

   procedure Update(Integration_Constant : in Float;
                    An_Instance          : in out Instance);

private

   type Instance is
      record
         Power                      : Boolean;
         High_Sense                 : Boolean;
         Aircraft_Position          : Radio_Types.Position_Type;
         Station                    : Jpats_Radio_Db_If_Types.Mrkr_Stn_Struct;
         Inner_VCA                  : Float;
         Middle_VCA                 : Float;
         Outer_VCA                  : Float;
         Inner_Receiving            : Boolean;
         Middle_Receiving           : Boolean;
         Outer_Receiving            : Boolean;
      end record;

end Marker_Beacon;
