-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Avionics_Types;
with Radio_Types;
with Jpats_Radio_Db_If_Types;

package JPATS_Radio_Types is

   package Jat renames Jpats_Avionics_Types;
   package Jrdb_If renames Jpats_Radio_Db_If_Types;

   subtype Ident_Type is String (1 .. 4);

   type Dme_Mode_Type is (Standby,Directed_Freq_1,Directed_Freq_2,
                          Directed_Freq_3,Hold_Freq_1,Hold_Freq_2,Free_Scan,
                          Spare);

   type Nav_Mode_Type is (Vor,Ils,Mls,Fms);

   type Dme_Tx_Type is
      record
         Ground_Speed : Float := 0.0;
         Dme_Mode     : Dme_Mode_Type := Standby;
         Nav_Mode     : Nav_Mode_Type := Vor;
         Display      : Boolean := False; --Enable,Disable
         Ident        : Boolean := False; --Audio on, off
         Frequency    : Integer := 0;
         Memory       : Boolean := False; --Memory on, off
         Foreground   : Boolean := False; --Foreground, not foreground
         Distance     : Float := 0.0;
         Time_To_Go   : Float := 0.0;
      end record;

   type Nav_Tx_Type is
      record
         Filtering            : Boolean := False; --no filtering, filtering
         Ils_Mode             : Boolean := False; --ils mode, vor mode
         Frequency            : Integer := 0;
         Localizer_Deviation  : Float := 0.0;
         Glideslope_Deviation : Float := 0.0;
         Outer_Marker_Beacon  : Boolean := False; --present, absent
         Middle_Marker_Beacon : Boolean := False; --present, absent
         Inner_Marker_Beacon  : Boolean := False; --present, absent
         Bearing              : Float := 0.0;
      end record;

   type Marker_Type is (Outer,Middle,Inner);

   type Marker_Audio_On_Type is array (Marker_Type) of Boolean;
   type Marker_Valid_Type is array (Marker_Type) of Boolean;
   type Marker_Vca_Type is array (Marker_Type) of Float;
   type Marker_Receiving_Type is array (Marker_Type) of Boolean;

   type Vhf_Status_Type is
      record
         Valid        : Boolean := False;
         Squelch      : Boolean := False;
         Transmitting : Boolean := False;
         Elt_Xmit     : Boolean := False;
         Frequency    : Integer := 0;
         Vca          : Float   := 0.0;
         Atis         : Boolean := False;
         Position     : Jat.Position_Type := (0.0,0.0,0.0);
         Typ2         : Jrdb_If.Bitfield;
         Aptid        : String(1..4) := "    ";
         Stnid        : String(1..4) := "    ";
         Icao         : String(1..4) := "    ";
      end record;

   type Uhf_Status_Type is
      record
         Valid        : Boolean := False;
         Squelch      : Boolean := False;
         Transmitting : Boolean := False;
         Elt_Xmit     : Boolean := False;
         Frequency    : Integer := 0;
         Vca          : Float   := 0.0;
         Tone         : Boolean := False;
         Atis         : Boolean := False;
         Position     : Jat.Position_Type := (0.0,0.0,0.0);
         Typ2         : Jrdb_If.Bitfield;
         Aptid        : String(1..4) := "    ";
         Stnid        : String(1..4) := "    ";
         Icao         : String(1..4) := "    ";
      end record;

   type Nav_Status_Type is
      record
         Valid                : Boolean := False;
         Ils_Freq_Selected    : Boolean := False;
         Localizer_Deviation  : Float := 0.0;
         Localizer_Valid      : Boolean := False;
         Glideslope_Deviation : Float := 0.0;
         Glideslope_Valid     : Boolean := False;
         Vor_Deviation        : Float := 0.0;
         To_From_Flag         : Radio_Types.Normalized_Type := 0.0;
         Frequency            : Integer := 0;
         Bearing              : Float   := 0.0;
         Ident                : Ident_Type := "    ";
         Vca                  : Float := 0.0;
         Om_Vca               : Float := 0.0;
         Mm_Vca               : Float := 0.0;
         Im_Vca               : Float := 0.0;
         Atis                 : Boolean := False;
         Position             : Jat.Position_Type := (0.0,0.0,0.0);
         Typ1                 : Jrdb_If.Bitfield;
         Typ2                 : Jrdb_If.Bitfield;
         Vor_Ncd              : Boolean := False;
         Glideslope_Rec_Fail  : Boolean := False;
         Nav_Power_Fail       : Boolean := False;
      end record;

   type Dme_Status_Type is
      record
         Valid : Boolean := False;
         Dme_Hold : Boolean := False;
         Frequency : Integer := 0;
         Ident             : Ident_Type := "    ";
         Vca               : Float := 0.0;
         Distance : Float := 0.0;
         Groundspeed : Float := 0.0;
         Ttg : Float := 0.0;
      end record;

   type Transponder_Status_Type is
      record
         Valid    : Boolean := False;
         Ident_On : Boolean := False;
         Mode     : Jpats_Avionics_Types.Xpdr_Mode_Select_Type;
         Test     : Boolean := False;
         Code     : Integer := 0;
      end record;

end JPATS_Radio_Types;
