-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  JK Reynolds
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_Radio.Container;
package body JPATS_Radio is

   function Magnetic_Variation
     return Float is
   begin
      return Container.This_Subsystem.The_Magnetic_Variation;
   end Magnetic_Variation;

   function Vhf_Status
     return Jrt.Vhf_Status_Type is
   begin
      return Container.This_Subsystem.The_Vhf_Status;
   end Vhf_Status;

   function Uhf_Status
     return Jrt.Uhf_Status_Type is
   begin
      return Container.This_Subsystem.The_Uhf_Status;
   end Uhf_Status;

   function Nav_Status
     return Jrt.Nav_Status_Type is
   begin
      return Container.This_Subsystem.The_Nav_Status;
   end Nav_Status;

   function Dme_Status
     return Jrt.Dme_Status_Type is
   begin
      return Container.This_Subsystem.The_Dme_Status;
   end Dme_Status;

   function Transponder_Status
     return Jrt.Transponder_Status_Type is
   begin
      return Container.This_Subsystem.The_Transponder_Status;
   end Transponder_Status;

end JPATS_Radio;
